package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class InventoryEntryCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private InventoryEntry inventoryEntry;

  private String type;

  public InventoryEntryCreated() {
  }

  public InventoryEntryCreated(InventoryEntry inventoryEntry, String type) {
    this.inventoryEntry = inventoryEntry;
    this.type = type;
  }

  public InventoryEntry getInventoryEntry() {
    return inventoryEntry;
  }

  public void setInventoryEntry(InventoryEntry inventoryEntry) {
    this.inventoryEntry = inventoryEntry;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "InventoryEntryCreated{inventoryEntry='" + inventoryEntry + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InventoryEntryCreated that = (InventoryEntryCreated) o;
    return Objects.equals(inventoryEntry, that.inventoryEntry) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(inventoryEntry, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private InventoryEntry inventoryEntry;

    private String type;

    public InventoryEntryCreated build() {
      InventoryEntryCreated result = new InventoryEntryCreated();
      result.inventoryEntry = this.inventoryEntry;
      result.type = this.type;
      return result;
    }

    public Builder inventoryEntry(InventoryEntry inventoryEntry) {
      this.inventoryEntry = inventoryEntry;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
