package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class InventoryEntryDraft {
  private String sku;

  private String key;

  private Long quantityOnStock;

  private Integer restockableInDays;

  private OffsetDateTime expectedDelivery;

  private ResourceIdentifierInput supplyChannel;

  private CustomFieldsDraft custom;

  public InventoryEntryDraft() {
  }

  public InventoryEntryDraft(String sku, String key, Long quantityOnStock,
      Integer restockableInDays, OffsetDateTime expectedDelivery,
      ResourceIdentifierInput supplyChannel, CustomFieldsDraft custom) {
    this.sku = sku;
    this.key = key;
    this.quantityOnStock = quantityOnStock;
    this.restockableInDays = restockableInDays;
    this.expectedDelivery = expectedDelivery;
    this.supplyChannel = supplyChannel;
    this.custom = custom;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Long getQuantityOnStock() {
    return quantityOnStock;
  }

  public void setQuantityOnStock(Long quantityOnStock) {
    this.quantityOnStock = quantityOnStock;
  }

  public Integer getRestockableInDays() {
    return restockableInDays;
  }

  public void setRestockableInDays(Integer restockableInDays) {
    this.restockableInDays = restockableInDays;
  }

  public OffsetDateTime getExpectedDelivery() {
    return expectedDelivery;
  }

  public void setExpectedDelivery(OffsetDateTime expectedDelivery) {
    this.expectedDelivery = expectedDelivery;
  }

  public ResourceIdentifierInput getSupplyChannel() {
    return supplyChannel;
  }

  public void setSupplyChannel(ResourceIdentifierInput supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "InventoryEntryDraft{sku='" + sku + "', key='" + key + "', quantityOnStock='" + quantityOnStock + "', restockableInDays='" + restockableInDays + "', expectedDelivery='" + expectedDelivery + "', supplyChannel='" + supplyChannel + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InventoryEntryDraft that = (InventoryEntryDraft) o;
    return Objects.equals(sku, that.sku) &&
        Objects.equals(key, that.key) &&
        Objects.equals(quantityOnStock, that.quantityOnStock) &&
        Objects.equals(restockableInDays, that.restockableInDays) &&
        Objects.equals(expectedDelivery, that.expectedDelivery) &&
        Objects.equals(supplyChannel, that.supplyChannel) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sku, key, quantityOnStock, restockableInDays, expectedDelivery, supplyChannel, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String sku;

    private String key;

    private Long quantityOnStock;

    private Integer restockableInDays;

    private OffsetDateTime expectedDelivery;

    private ResourceIdentifierInput supplyChannel;

    private CustomFieldsDraft custom;

    public InventoryEntryDraft build() {
      InventoryEntryDraft result = new InventoryEntryDraft();
      result.sku = this.sku;
      result.key = this.key;
      result.quantityOnStock = this.quantityOnStock;
      result.restockableInDays = this.restockableInDays;
      result.expectedDelivery = this.expectedDelivery;
      result.supplyChannel = this.supplyChannel;
      result.custom = this.custom;
      return result;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder quantityOnStock(Long quantityOnStock) {
      this.quantityOnStock = quantityOnStock;
      return this;
    }

    public Builder restockableInDays(Integer restockableInDays) {
      this.restockableInDays = restockableInDays;
      return this;
    }

    public Builder expectedDelivery(OffsetDateTime expectedDelivery) {
      this.expectedDelivery = expectedDelivery;
      return this;
    }

    public Builder supplyChannel(ResourceIdentifierInput supplyChannel) {
      this.supplyChannel = supplyChannel;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
