package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ItemShippingDetailsDraftType {
  private List<ShippingTargetDraftType> targets;

  public ItemShippingDetailsDraftType() {
  }

  public ItemShippingDetailsDraftType(List<ShippingTargetDraftType> targets) {
    this.targets = targets;
  }

  public List<ShippingTargetDraftType> getTargets() {
    return targets;
  }

  public void setTargets(List<ShippingTargetDraftType> targets) {
    this.targets = targets;
  }

  @Override
  public String toString() {
    return "ItemShippingDetailsDraftType{targets='" + targets + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ItemShippingDetailsDraftType that = (ItemShippingDetailsDraftType) o;
    return Objects.equals(targets, that.targets);
  }

  @Override
  public int hashCode() {
    return Objects.hash(targets);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ShippingTargetDraftType> targets;

    public ItemShippingDetailsDraftType build() {
      ItemShippingDetailsDraftType result = new ItemShippingDetailsDraftType();
      result.targets = this.targets;
      return result;
    }

    public Builder targets(List<ShippingTargetDraftType> targets) {
      this.targets = targets;
      return this;
    }
  }
}
