package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ItemState {
  private Long quantity;

  private Reference stateRef;

  private State state;

  public ItemState() {
  }

  public ItemState(Long quantity, Reference stateRef, State state) {
    this.quantity = quantity;
    this.stateRef = stateRef;
    this.state = state;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public Reference getStateRef() {
    return stateRef;
  }

  public void setStateRef(Reference stateRef) {
    this.stateRef = stateRef;
  }

  public State getState() {
    return state;
  }

  public void setState(State state) {
    this.state = state;
  }

  @Override
  public String toString() {
    return "ItemState{quantity='" + quantity + "', stateRef='" + stateRef + "', state='" + state + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ItemState that = (ItemState) o;
    return Objects.equals(quantity, that.quantity) &&
        Objects.equals(stateRef, that.stateRef) &&
        Objects.equals(state, that.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quantity, stateRef, state);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Long quantity;

    private Reference stateRef;

    private State state;

    public ItemState build() {
      ItemState result = new ItemState();
      result.quantity = this.quantity;
      result.stateRef = this.stateRef;
      result.state = this.state;
      return result;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder stateRef(Reference stateRef) {
      this.stateRef = stateRef;
      return this;
    }

    public Builder state(State state) {
      this.state = state;
      return this;
    }
  }
}
