package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class Limit {
  private Long limit;

  public Limit() {
  }

  public Limit(Long limit) {
    this.limit = limit;
  }

  public Long getLimit() {
    return limit;
  }

  public void setLimit(Long limit) {
    this.limit = limit;
  }

  @Override
  public String toString() {
    return "Limit{limit='" + limit + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Limit that = (Limit) o;
    return Objects.equals(limit, that.limit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(limit);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Long limit;

    public Limit build() {
      Limit result = new Limit();
      result.limit = this.limit;
      return result;
    }

    public Builder limit(Long limit) {
      this.limit = limit;
      return this;
    }
  }
}
