package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

/**
 * A line item is a snapshot of a product variant at the time it was added to the cart.
 *
 * Since a product variant may change at any time, the ProductVariant data is copied into the field variant.
 * The relation to the Product is kept but the line item will not automatically update if the product variant changes.
 * On the cart, the line item can be updated manually. The productSlug refers to the current version of the product.
 * It can be used to link to the product. If the product has been deleted, the line item remains but refers to a
 * non-existent product and the productSlug is left empty.
 *
 * Please also note that creating an order is impossible if the product or product variant a line item relates to has been deleted.
 */
public class LineItem {
  private String id;

  private String key;

  private String productId;

  private String productKey;

  private String name;

  private List<LocalizedString> nameAllLocales;

  private String productSlug;

  private List<LocalizedString> productSlugAllLocales;

  private ProductTypeDefinition productType;

  private Reference productTypeRef;

  private ProductVariant variant;

  private ProductPrice price;

  private TaxedItemPrice taxedPrice;

  private Money totalPrice;

  private Long quantity;

  private OffsetDateTime addedAt;

  private OffsetDateTime lastModifiedAt;

  private List<ItemState> state;

  private TaxRate taxRate;

  private Channel supplyChannel;

  private Reference supplyChannelRef;

  private Channel distributionChannel;

  private Reference distributionChannelRef;

  private List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity;

  private LineItemMode lineItemMode;

  private LineItemPriceMode priceMode;

  private CustomFieldsType custom;

  private InventoryMode inventoryMode;

  private ItemShippingDetails shippingDetails;

  private List<MethodTaxRate> perMethodTaxRate;

  private List<MethodTaxedPrice> taxedPricePortions;

  public LineItem() {
  }

  public LineItem(String id, String key, String productId, String productKey, String name,
      List<LocalizedString> nameAllLocales, String productSlug,
      List<LocalizedString> productSlugAllLocales, ProductTypeDefinition productType,
      Reference productTypeRef, ProductVariant variant, ProductPrice price,
      TaxedItemPrice taxedPrice, Money totalPrice, Long quantity, OffsetDateTime addedAt,
      OffsetDateTime lastModifiedAt, List<ItemState> state, TaxRate taxRate, Channel supplyChannel,
      Reference supplyChannelRef, Channel distributionChannel, Reference distributionChannelRef,
      List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity,
      LineItemMode lineItemMode, LineItemPriceMode priceMode, CustomFieldsType custom,
      InventoryMode inventoryMode, ItemShippingDetails shippingDetails,
      List<MethodTaxRate> perMethodTaxRate, List<MethodTaxedPrice> taxedPricePortions) {
    this.id = id;
    this.key = key;
    this.productId = productId;
    this.productKey = productKey;
    this.name = name;
    this.nameAllLocales = nameAllLocales;
    this.productSlug = productSlug;
    this.productSlugAllLocales = productSlugAllLocales;
    this.productType = productType;
    this.productTypeRef = productTypeRef;
    this.variant = variant;
    this.price = price;
    this.taxedPrice = taxedPrice;
    this.totalPrice = totalPrice;
    this.quantity = quantity;
    this.addedAt = addedAt;
    this.lastModifiedAt = lastModifiedAt;
    this.state = state;
    this.taxRate = taxRate;
    this.supplyChannel = supplyChannel;
    this.supplyChannelRef = supplyChannelRef;
    this.distributionChannel = distributionChannel;
    this.distributionChannelRef = distributionChannelRef;
    this.discountedPricePerQuantity = discountedPricePerQuantity;
    this.lineItemMode = lineItemMode;
    this.priceMode = priceMode;
    this.custom = custom;
    this.inventoryMode = inventoryMode;
    this.shippingDetails = shippingDetails;
    this.perMethodTaxRate = perMethodTaxRate;
    this.taxedPricePortions = taxedPricePortions;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getProductId() {
    return productId;
  }

  public void setProductId(String productId) {
    this.productId = productId;
  }

  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public String getProductSlug() {
    return productSlug;
  }

  public void setProductSlug(String productSlug) {
    this.productSlug = productSlug;
  }

  public List<LocalizedString> getProductSlugAllLocales() {
    return productSlugAllLocales;
  }

  public void setProductSlugAllLocales(List<LocalizedString> productSlugAllLocales) {
    this.productSlugAllLocales = productSlugAllLocales;
  }

  public ProductTypeDefinition getProductType() {
    return productType;
  }

  public void setProductType(ProductTypeDefinition productType) {
    this.productType = productType;
  }

  public Reference getProductTypeRef() {
    return productTypeRef;
  }

  public void setProductTypeRef(Reference productTypeRef) {
    this.productTypeRef = productTypeRef;
  }

  public ProductVariant getVariant() {
    return variant;
  }

  public void setVariant(ProductVariant variant) {
    this.variant = variant;
  }

  public ProductPrice getPrice() {
    return price;
  }

  public void setPrice(ProductPrice price) {
    this.price = price;
  }

  public TaxedItemPrice getTaxedPrice() {
    return taxedPrice;
  }

  public void setTaxedPrice(TaxedItemPrice taxedPrice) {
    this.taxedPrice = taxedPrice;
  }

  public Money getTotalPrice() {
    return totalPrice;
  }

  public void setTotalPrice(Money totalPrice) {
    this.totalPrice = totalPrice;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public OffsetDateTime getAddedAt() {
    return addedAt;
  }

  public void setAddedAt(OffsetDateTime addedAt) {
    this.addedAt = addedAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public List<ItemState> getState() {
    return state;
  }

  public void setState(List<ItemState> state) {
    this.state = state;
  }

  public TaxRate getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(TaxRate taxRate) {
    this.taxRate = taxRate;
  }

  public Channel getSupplyChannel() {
    return supplyChannel;
  }

  public void setSupplyChannel(Channel supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  public Reference getSupplyChannelRef() {
    return supplyChannelRef;
  }

  public void setSupplyChannelRef(Reference supplyChannelRef) {
    this.supplyChannelRef = supplyChannelRef;
  }

  public Channel getDistributionChannel() {
    return distributionChannel;
  }

  public void setDistributionChannel(Channel distributionChannel) {
    this.distributionChannel = distributionChannel;
  }

  public Reference getDistributionChannelRef() {
    return distributionChannelRef;
  }

  public void setDistributionChannelRef(Reference distributionChannelRef) {
    this.distributionChannelRef = distributionChannelRef;
  }

  public List<DiscountedLineItemPriceForQuantity> getDiscountedPricePerQuantity() {
    return discountedPricePerQuantity;
  }

  public void setDiscountedPricePerQuantity(
      List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity) {
    this.discountedPricePerQuantity = discountedPricePerQuantity;
  }

  public LineItemMode getLineItemMode() {
    return lineItemMode;
  }

  public void setLineItemMode(LineItemMode lineItemMode) {
    this.lineItemMode = lineItemMode;
  }

  public LineItemPriceMode getPriceMode() {
    return priceMode;
  }

  public void setPriceMode(LineItemPriceMode priceMode) {
    this.priceMode = priceMode;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public InventoryMode getInventoryMode() {
    return inventoryMode;
  }

  public void setInventoryMode(InventoryMode inventoryMode) {
    this.inventoryMode = inventoryMode;
  }

  public ItemShippingDetails getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetails shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  public List<MethodTaxRate> getPerMethodTaxRate() {
    return perMethodTaxRate;
  }

  public void setPerMethodTaxRate(List<MethodTaxRate> perMethodTaxRate) {
    this.perMethodTaxRate = perMethodTaxRate;
  }

  public List<MethodTaxedPrice> getTaxedPricePortions() {
    return taxedPricePortions;
  }

  public void setTaxedPricePortions(List<MethodTaxedPrice> taxedPricePortions) {
    this.taxedPricePortions = taxedPricePortions;
  }

  @Override
  public String toString() {
    return "LineItem{id='" + id + "', key='" + key + "', productId='" + productId + "', productKey='" + productKey + "', name='" + name + "', nameAllLocales='" + nameAllLocales + "', productSlug='" + productSlug + "', productSlugAllLocales='" + productSlugAllLocales + "', productType='" + productType + "', productTypeRef='" + productTypeRef + "', variant='" + variant + "', price='" + price + "', taxedPrice='" + taxedPrice + "', totalPrice='" + totalPrice + "', quantity='" + quantity + "', addedAt='" + addedAt + "', lastModifiedAt='" + lastModifiedAt + "', state='" + state + "', taxRate='" + taxRate + "', supplyChannel='" + supplyChannel + "', supplyChannelRef='" + supplyChannelRef + "', distributionChannel='" + distributionChannel + "', distributionChannelRef='" + distributionChannelRef + "', discountedPricePerQuantity='" + discountedPricePerQuantity + "', lineItemMode='" + lineItemMode + "', priceMode='" + priceMode + "', custom='" + custom + "', inventoryMode='" + inventoryMode + "', shippingDetails='" + shippingDetails + "', perMethodTaxRate='" + perMethodTaxRate + "', taxedPricePortions='" + taxedPricePortions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LineItem that = (LineItem) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(key, that.key) &&
        Objects.equals(productId, that.productId) &&
        Objects.equals(productKey, that.productKey) &&
        Objects.equals(name, that.name) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(productSlug, that.productSlug) &&
        Objects.equals(productSlugAllLocales, that.productSlugAllLocales) &&
        Objects.equals(productType, that.productType) &&
        Objects.equals(productTypeRef, that.productTypeRef) &&
        Objects.equals(variant, that.variant) &&
        Objects.equals(price, that.price) &&
        Objects.equals(taxedPrice, that.taxedPrice) &&
        Objects.equals(totalPrice, that.totalPrice) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(addedAt, that.addedAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(state, that.state) &&
        Objects.equals(taxRate, that.taxRate) &&
        Objects.equals(supplyChannel, that.supplyChannel) &&
        Objects.equals(supplyChannelRef, that.supplyChannelRef) &&
        Objects.equals(distributionChannel, that.distributionChannel) &&
        Objects.equals(distributionChannelRef, that.distributionChannelRef) &&
        Objects.equals(discountedPricePerQuantity, that.discountedPricePerQuantity) &&
        Objects.equals(lineItemMode, that.lineItemMode) &&
        Objects.equals(priceMode, that.priceMode) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(inventoryMode, that.inventoryMode) &&
        Objects.equals(shippingDetails, that.shippingDetails) &&
        Objects.equals(perMethodTaxRate, that.perMethodTaxRate) &&
        Objects.equals(taxedPricePortions, that.taxedPricePortions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, key, productId, productKey, name, nameAllLocales, productSlug, productSlugAllLocales, productType, productTypeRef, variant, price, taxedPrice, totalPrice, quantity, addedAt, lastModifiedAt, state, taxRate, supplyChannel, supplyChannelRef, distributionChannel, distributionChannelRef, discountedPricePerQuantity, lineItemMode, priceMode, custom, inventoryMode, shippingDetails, perMethodTaxRate, taxedPricePortions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private String key;

    private String productId;

    private String productKey;

    private String name;

    private List<LocalizedString> nameAllLocales;

    private String productSlug;

    private List<LocalizedString> productSlugAllLocales;

    private ProductTypeDefinition productType;

    private Reference productTypeRef;

    private ProductVariant variant;

    private ProductPrice price;

    private TaxedItemPrice taxedPrice;

    private Money totalPrice;

    private Long quantity;

    private OffsetDateTime addedAt;

    private OffsetDateTime lastModifiedAt;

    private List<ItemState> state;

    private TaxRate taxRate;

    private Channel supplyChannel;

    private Reference supplyChannelRef;

    private Channel distributionChannel;

    private Reference distributionChannelRef;

    private List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity;

    private LineItemMode lineItemMode;

    private LineItemPriceMode priceMode;

    private CustomFieldsType custom;

    private InventoryMode inventoryMode;

    private ItemShippingDetails shippingDetails;

    private List<MethodTaxRate> perMethodTaxRate;

    private List<MethodTaxedPrice> taxedPricePortions;

    public LineItem build() {
      LineItem result = new LineItem();
      result.id = this.id;
      result.key = this.key;
      result.productId = this.productId;
      result.productKey = this.productKey;
      result.name = this.name;
      result.nameAllLocales = this.nameAllLocales;
      result.productSlug = this.productSlug;
      result.productSlugAllLocales = this.productSlugAllLocales;
      result.productType = this.productType;
      result.productTypeRef = this.productTypeRef;
      result.variant = this.variant;
      result.price = this.price;
      result.taxedPrice = this.taxedPrice;
      result.totalPrice = this.totalPrice;
      result.quantity = this.quantity;
      result.addedAt = this.addedAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.state = this.state;
      result.taxRate = this.taxRate;
      result.supplyChannel = this.supplyChannel;
      result.supplyChannelRef = this.supplyChannelRef;
      result.distributionChannel = this.distributionChannel;
      result.distributionChannelRef = this.distributionChannelRef;
      result.discountedPricePerQuantity = this.discountedPricePerQuantity;
      result.lineItemMode = this.lineItemMode;
      result.priceMode = this.priceMode;
      result.custom = this.custom;
      result.inventoryMode = this.inventoryMode;
      result.shippingDetails = this.shippingDetails;
      result.perMethodTaxRate = this.perMethodTaxRate;
      result.taxedPricePortions = this.taxedPricePortions;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder productId(String productId) {
      this.productId = productId;
      return this;
    }

    public Builder productKey(String productKey) {
      this.productKey = productKey;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder productSlug(String productSlug) {
      this.productSlug = productSlug;
      return this;
    }

    public Builder productSlugAllLocales(List<LocalizedString> productSlugAllLocales) {
      this.productSlugAllLocales = productSlugAllLocales;
      return this;
    }

    public Builder productType(ProductTypeDefinition productType) {
      this.productType = productType;
      return this;
    }

    public Builder productTypeRef(Reference productTypeRef) {
      this.productTypeRef = productTypeRef;
      return this;
    }

    public Builder variant(ProductVariant variant) {
      this.variant = variant;
      return this;
    }

    public Builder price(ProductPrice price) {
      this.price = price;
      return this;
    }

    public Builder taxedPrice(TaxedItemPrice taxedPrice) {
      this.taxedPrice = taxedPrice;
      return this;
    }

    public Builder totalPrice(Money totalPrice) {
      this.totalPrice = totalPrice;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder addedAt(OffsetDateTime addedAt) {
      this.addedAt = addedAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder state(List<ItemState> state) {
      this.state = state;
      return this;
    }

    public Builder taxRate(TaxRate taxRate) {
      this.taxRate = taxRate;
      return this;
    }

    public Builder supplyChannel(Channel supplyChannel) {
      this.supplyChannel = supplyChannel;
      return this;
    }

    public Builder supplyChannelRef(Reference supplyChannelRef) {
      this.supplyChannelRef = supplyChannelRef;
      return this;
    }

    public Builder distributionChannel(Channel distributionChannel) {
      this.distributionChannel = distributionChannel;
      return this;
    }

    public Builder distributionChannelRef(Reference distributionChannelRef) {
      this.distributionChannelRef = distributionChannelRef;
      return this;
    }

    public Builder discountedPricePerQuantity(
        List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity) {
      this.discountedPricePerQuantity = discountedPricePerQuantity;
      return this;
    }

    public Builder lineItemMode(LineItemMode lineItemMode) {
      this.lineItemMode = lineItemMode;
      return this;
    }

    public Builder priceMode(LineItemPriceMode priceMode) {
      this.priceMode = priceMode;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder inventoryMode(InventoryMode inventoryMode) {
      this.inventoryMode = inventoryMode;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetails shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }

    public Builder perMethodTaxRate(List<MethodTaxRate> perMethodTaxRate) {
      this.perMethodTaxRate = perMethodTaxRate;
      return this;
    }

    public Builder taxedPricePortions(List<MethodTaxedPrice> taxedPricePortions) {
      this.taxedPricePortions = taxedPricePortions;
      return this;
    }
  }
}
