package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class LineItemDraftOutput {
  private String productId;

  private String sku;

  private String key;

  private Long quantity;

  private Integer variantId;

  private CustomFieldsCommand custom;

  private ExternalTaxRateDraftOutput externalTaxRate;

  private List<MethodExternalTaxRateDraftOutput> perMethodExternalTaxRate;

  private BaseMoney externalPrice;

  private ExternalLineItemTotalPrice externalTotalPrice;

  private InventoryMode inventoryMode;

  private ItemShippingDetailsDraftOutput shippingDetails;

  private OffsetDateTime addedAt;

  private ResourceIdentifier distributionChannelResId;

  private ResourceIdentifier supplyChannelResId;

  public LineItemDraftOutput() {
  }

  public LineItemDraftOutput(String productId, String sku, String key, Long quantity,
      Integer variantId, CustomFieldsCommand custom, ExternalTaxRateDraftOutput externalTaxRate,
      List<MethodExternalTaxRateDraftOutput> perMethodExternalTaxRate, BaseMoney externalPrice,
      ExternalLineItemTotalPrice externalTotalPrice, InventoryMode inventoryMode,
      ItemShippingDetailsDraftOutput shippingDetails, OffsetDateTime addedAt,
      ResourceIdentifier distributionChannelResId, ResourceIdentifier supplyChannelResId) {
    this.productId = productId;
    this.sku = sku;
    this.key = key;
    this.quantity = quantity;
    this.variantId = variantId;
    this.custom = custom;
    this.externalTaxRate = externalTaxRate;
    this.perMethodExternalTaxRate = perMethodExternalTaxRate;
    this.externalPrice = externalPrice;
    this.externalTotalPrice = externalTotalPrice;
    this.inventoryMode = inventoryMode;
    this.shippingDetails = shippingDetails;
    this.addedAt = addedAt;
    this.distributionChannelResId = distributionChannelResId;
    this.supplyChannelResId = supplyChannelResId;
  }

  public String getProductId() {
    return productId;
  }

  public void setProductId(String productId) {
    this.productId = productId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  public ExternalTaxRateDraftOutput getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public List<MethodExternalTaxRateDraftOutput> getPerMethodExternalTaxRate() {
    return perMethodExternalTaxRate;
  }

  public void setPerMethodExternalTaxRate(
      List<MethodExternalTaxRateDraftOutput> perMethodExternalTaxRate) {
    this.perMethodExternalTaxRate = perMethodExternalTaxRate;
  }

  public BaseMoney getExternalPrice() {
    return externalPrice;
  }

  public void setExternalPrice(BaseMoney externalPrice) {
    this.externalPrice = externalPrice;
  }

  public ExternalLineItemTotalPrice getExternalTotalPrice() {
    return externalTotalPrice;
  }

  public void setExternalTotalPrice(ExternalLineItemTotalPrice externalTotalPrice) {
    this.externalTotalPrice = externalTotalPrice;
  }

  public InventoryMode getInventoryMode() {
    return inventoryMode;
  }

  public void setInventoryMode(InventoryMode inventoryMode) {
    this.inventoryMode = inventoryMode;
  }

  public ItemShippingDetailsDraftOutput getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraftOutput shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  public OffsetDateTime getAddedAt() {
    return addedAt;
  }

  public void setAddedAt(OffsetDateTime addedAt) {
    this.addedAt = addedAt;
  }

  public ResourceIdentifier getDistributionChannelResId() {
    return distributionChannelResId;
  }

  public void setDistributionChannelResId(ResourceIdentifier distributionChannelResId) {
    this.distributionChannelResId = distributionChannelResId;
  }

  public ResourceIdentifier getSupplyChannelResId() {
    return supplyChannelResId;
  }

  public void setSupplyChannelResId(ResourceIdentifier supplyChannelResId) {
    this.supplyChannelResId = supplyChannelResId;
  }

  @Override
  public String toString() {
    return "LineItemDraftOutput{productId='" + productId + "', sku='" + sku + "', key='" + key + "', quantity='" + quantity + "', variantId='" + variantId + "', custom='" + custom + "', externalTaxRate='" + externalTaxRate + "', perMethodExternalTaxRate='" + perMethodExternalTaxRate + "', externalPrice='" + externalPrice + "', externalTotalPrice='" + externalTotalPrice + "', inventoryMode='" + inventoryMode + "', shippingDetails='" + shippingDetails + "', addedAt='" + addedAt + "', distributionChannelResId='" + distributionChannelResId + "', supplyChannelResId='" + supplyChannelResId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LineItemDraftOutput that = (LineItemDraftOutput) o;
    return Objects.equals(productId, that.productId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(key, that.key) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(variantId, that.variantId) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(perMethodExternalTaxRate, that.perMethodExternalTaxRate) &&
        Objects.equals(externalPrice, that.externalPrice) &&
        Objects.equals(externalTotalPrice, that.externalTotalPrice) &&
        Objects.equals(inventoryMode, that.inventoryMode) &&
        Objects.equals(shippingDetails, that.shippingDetails) &&
        Objects.equals(addedAt, that.addedAt) &&
        Objects.equals(distributionChannelResId, that.distributionChannelResId) &&
        Objects.equals(supplyChannelResId, that.supplyChannelResId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productId, sku, key, quantity, variantId, custom, externalTaxRate, perMethodExternalTaxRate, externalPrice, externalTotalPrice, inventoryMode, shippingDetails, addedAt, distributionChannelResId, supplyChannelResId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String productId;

    private String sku;

    private String key;

    private Long quantity;

    private Integer variantId;

    private CustomFieldsCommand custom;

    private ExternalTaxRateDraftOutput externalTaxRate;

    private List<MethodExternalTaxRateDraftOutput> perMethodExternalTaxRate;

    private BaseMoney externalPrice;

    private ExternalLineItemTotalPrice externalTotalPrice;

    private InventoryMode inventoryMode;

    private ItemShippingDetailsDraftOutput shippingDetails;

    private OffsetDateTime addedAt;

    private ResourceIdentifier distributionChannelResId;

    private ResourceIdentifier supplyChannelResId;

    public LineItemDraftOutput build() {
      LineItemDraftOutput result = new LineItemDraftOutput();
      result.productId = this.productId;
      result.sku = this.sku;
      result.key = this.key;
      result.quantity = this.quantity;
      result.variantId = this.variantId;
      result.custom = this.custom;
      result.externalTaxRate = this.externalTaxRate;
      result.perMethodExternalTaxRate = this.perMethodExternalTaxRate;
      result.externalPrice = this.externalPrice;
      result.externalTotalPrice = this.externalTotalPrice;
      result.inventoryMode = this.inventoryMode;
      result.shippingDetails = this.shippingDetails;
      result.addedAt = this.addedAt;
      result.distributionChannelResId = this.distributionChannelResId;
      result.supplyChannelResId = this.supplyChannelResId;
      return result;
    }

    public Builder productId(String productId) {
      this.productId = productId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder perMethodExternalTaxRate(
        List<MethodExternalTaxRateDraftOutput> perMethodExternalTaxRate) {
      this.perMethodExternalTaxRate = perMethodExternalTaxRate;
      return this;
    }

    public Builder externalPrice(BaseMoney externalPrice) {
      this.externalPrice = externalPrice;
      return this;
    }

    public Builder externalTotalPrice(ExternalLineItemTotalPrice externalTotalPrice) {
      this.externalTotalPrice = externalTotalPrice;
      return this;
    }

    public Builder inventoryMode(InventoryMode inventoryMode) {
      this.inventoryMode = inventoryMode;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraftOutput shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }

    public Builder addedAt(OffsetDateTime addedAt) {
      this.addedAt = addedAt;
      return this;
    }

    public Builder distributionChannelResId(ResourceIdentifier distributionChannelResId) {
      this.distributionChannelResId = distributionChannelResId;
      return this;
    }

    public Builder supplyChannelResId(ResourceIdentifier supplyChannelResId) {
      this.supplyChannelResId = supplyChannelResId;
      return this;
    }
  }
}
