package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class LineItemImportDraft {
  private String productId;

  private List<LocalizedStringItemInputType> name;

  private String key;

  private ProductPriceDataInput price;

  private Long quantity;

  private ResourceIdentifierInput supplyChannel;

  private ResourceIdentifierInput distributionChannel;

  private TaxRateInput taxRate;

  private ProductVariantImportDraft variant;

  private List<ItemStateDraftType> state;

  private CustomFieldsDraft custom;

  private ItemShippingDetailsDraft shippingDetails;

  public LineItemImportDraft() {
  }

  public LineItemImportDraft(String productId, List<LocalizedStringItemInputType> name, String key,
      ProductPriceDataInput price, Long quantity, ResourceIdentifierInput supplyChannel,
      ResourceIdentifierInput distributionChannel, TaxRateInput taxRate,
      ProductVariantImportDraft variant, List<ItemStateDraftType> state, CustomFieldsDraft custom,
      ItemShippingDetailsDraft shippingDetails) {
    this.productId = productId;
    this.name = name;
    this.key = key;
    this.price = price;
    this.quantity = quantity;
    this.supplyChannel = supplyChannel;
    this.distributionChannel = distributionChannel;
    this.taxRate = taxRate;
    this.variant = variant;
    this.state = state;
    this.custom = custom;
    this.shippingDetails = shippingDetails;
  }

  public String getProductId() {
    return productId;
  }

  public void setProductId(String productId) {
    this.productId = productId;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public ProductPriceDataInput getPrice() {
    return price;
  }

  public void setPrice(ProductPriceDataInput price) {
    this.price = price;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public ResourceIdentifierInput getSupplyChannel() {
    return supplyChannel;
  }

  public void setSupplyChannel(ResourceIdentifierInput supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  public ResourceIdentifierInput getDistributionChannel() {
    return distributionChannel;
  }

  public void setDistributionChannel(ResourceIdentifierInput distributionChannel) {
    this.distributionChannel = distributionChannel;
  }

  public TaxRateInput getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(TaxRateInput taxRate) {
    this.taxRate = taxRate;
  }

  public ProductVariantImportDraft getVariant() {
    return variant;
  }

  public void setVariant(ProductVariantImportDraft variant) {
    this.variant = variant;
  }

  public List<ItemStateDraftType> getState() {
    return state;
  }

  public void setState(List<ItemStateDraftType> state) {
    this.state = state;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public ItemShippingDetailsDraft getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraft shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  @Override
  public String toString() {
    return "LineItemImportDraft{productId='" + productId + "', name='" + name + "', key='" + key + "', price='" + price + "', quantity='" + quantity + "', supplyChannel='" + supplyChannel + "', distributionChannel='" + distributionChannel + "', taxRate='" + taxRate + "', variant='" + variant + "', state='" + state + "', custom='" + custom + "', shippingDetails='" + shippingDetails + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LineItemImportDraft that = (LineItemImportDraft) o;
    return Objects.equals(productId, that.productId) &&
        Objects.equals(name, that.name) &&
        Objects.equals(key, that.key) &&
        Objects.equals(price, that.price) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(supplyChannel, that.supplyChannel) &&
        Objects.equals(distributionChannel, that.distributionChannel) &&
        Objects.equals(taxRate, that.taxRate) &&
        Objects.equals(variant, that.variant) &&
        Objects.equals(state, that.state) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(shippingDetails, that.shippingDetails);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productId, name, key, price, quantity, supplyChannel, distributionChannel, taxRate, variant, state, custom, shippingDetails);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String productId;

    private List<LocalizedStringItemInputType> name;

    private String key;

    private ProductPriceDataInput price;

    private Long quantity;

    private ResourceIdentifierInput supplyChannel;

    private ResourceIdentifierInput distributionChannel;

    private TaxRateInput taxRate;

    private ProductVariantImportDraft variant;

    private List<ItemStateDraftType> state;

    private CustomFieldsDraft custom;

    private ItemShippingDetailsDraft shippingDetails;

    public LineItemImportDraft build() {
      LineItemImportDraft result = new LineItemImportDraft();
      result.productId = this.productId;
      result.name = this.name;
      result.key = this.key;
      result.price = this.price;
      result.quantity = this.quantity;
      result.supplyChannel = this.supplyChannel;
      result.distributionChannel = this.distributionChannel;
      result.taxRate = this.taxRate;
      result.variant = this.variant;
      result.state = this.state;
      result.custom = this.custom;
      result.shippingDetails = this.shippingDetails;
      return result;
    }

    public Builder productId(String productId) {
      this.productId = productId;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder price(ProductPriceDataInput price) {
      this.price = price;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder supplyChannel(ResourceIdentifierInput supplyChannel) {
      this.supplyChannel = supplyChannel;
      return this;
    }

    public Builder distributionChannel(ResourceIdentifierInput distributionChannel) {
      this.distributionChannel = distributionChannel;
      return this;
    }

    public Builder taxRate(TaxRateInput taxRate) {
      this.taxRate = taxRate;
      return this;
    }

    public Builder variant(ProductVariantImportDraft variant) {
      this.variant = variant;
      return this;
    }

    public Builder state(List<ItemStateDraftType> state) {
      this.state = state;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraft shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }
  }
}
