package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class LineItemStateTransition implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String lineItemId;

  private String lineItemKey;

  private OffsetDateTime transitionDate;

  private Long quantity;

  private State fromState;

  private State toState;

  private Reference fromStateRef;

  private Reference toStateRef;

  private String type;

  public LineItemStateTransition() {
  }

  public LineItemStateTransition(String lineItemId, String lineItemKey,
      OffsetDateTime transitionDate, Long quantity, State fromState, State toState,
      Reference fromStateRef, Reference toStateRef, String type) {
    this.lineItemId = lineItemId;
    this.lineItemKey = lineItemKey;
    this.transitionDate = transitionDate;
    this.quantity = quantity;
    this.fromState = fromState;
    this.toState = toState;
    this.fromStateRef = fromStateRef;
    this.toStateRef = toStateRef;
    this.type = type;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  public OffsetDateTime getTransitionDate() {
    return transitionDate;
  }

  public void setTransitionDate(OffsetDateTime transitionDate) {
    this.transitionDate = transitionDate;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public State getFromState() {
    return fromState;
  }

  public void setFromState(State fromState) {
    this.fromState = fromState;
  }

  public State getToState() {
    return toState;
  }

  public void setToState(State toState) {
    this.toState = toState;
  }

  public Reference getFromStateRef() {
    return fromStateRef;
  }

  public void setFromStateRef(Reference fromStateRef) {
    this.fromStateRef = fromStateRef;
  }

  public Reference getToStateRef() {
    return toStateRef;
  }

  public void setToStateRef(Reference toStateRef) {
    this.toStateRef = toStateRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "LineItemStateTransition{lineItemId='" + lineItemId + "', lineItemKey='" + lineItemKey + "', transitionDate='" + transitionDate + "', quantity='" + quantity + "', fromState='" + fromState + "', toState='" + toState + "', fromStateRef='" + fromStateRef + "', toStateRef='" + toStateRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LineItemStateTransition that = (LineItemStateTransition) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(lineItemKey, that.lineItemKey) &&
        Objects.equals(transitionDate, that.transitionDate) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(fromState, that.fromState) &&
        Objects.equals(toState, that.toState) &&
        Objects.equals(fromStateRef, that.fromStateRef) &&
        Objects.equals(toStateRef, that.toStateRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, lineItemKey, transitionDate, quantity, fromState, toState, fromStateRef, toStateRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private String lineItemKey;

    private OffsetDateTime transitionDate;

    private Long quantity;

    private State fromState;

    private State toState;

    private Reference fromStateRef;

    private Reference toStateRef;

    private String type;

    public LineItemStateTransition build() {
      LineItemStateTransition result = new LineItemStateTransition();
      result.lineItemId = this.lineItemId;
      result.lineItemKey = this.lineItemKey;
      result.transitionDate = this.transitionDate;
      result.quantity = this.quantity;
      result.fromState = this.fromState;
      result.toState = this.toState;
      result.fromStateRef = this.fromStateRef;
      result.toStateRef = this.toStateRef;
      result.type = this.type;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }

    public Builder transitionDate(OffsetDateTime transitionDate) {
      this.transitionDate = transitionDate;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder fromState(State fromState) {
      this.fromState = fromState;
      return this;
    }

    public Builder toState(State toState) {
      this.toState = toState;
      return this;
    }

    public Builder fromStateRef(Reference fromStateRef) {
      this.fromStateRef = fromStateRef;
      return this;
    }

    public Builder toStateRef(Reference toStateRef) {
      this.toStateRef = toStateRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
