package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class LineItemsTarget implements com.commercetools.graphql.api.types.CartDiscountTarget {
  private String predicate;

  private String type;

  public LineItemsTarget() {
  }

  public LineItemsTarget(String predicate, String type) {
    this.predicate = predicate;
    this.type = type;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "LineItemsTarget{predicate='" + predicate + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LineItemsTarget that = (LineItemsTarget) o;
    return Objects.equals(predicate, that.predicate) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(predicate, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String predicate;

    private String type;

    public LineItemsTarget build() {
      LineItemsTarget result = new LineItemsTarget();
      result.predicate = this.predicate;
      result.type = this.type;
      return result;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
