package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class LineItemsTargetInput {
  private String predicate;

  public LineItemsTargetInput() {
  }

  public LineItemsTargetInput(String predicate) {
    this.predicate = predicate;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  @Override
  public String toString() {
    return "LineItemsTargetInput{predicate='" + predicate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LineItemsTargetInput that = (LineItemsTargetInput) o;
    return Objects.equals(predicate, that.predicate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(predicate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String predicate;

    public LineItemsTargetInput build() {
      LineItemsTargetInput result = new LineItemsTargetInput();
      result.predicate = this.predicate;
      return result;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }
  }
}
