package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class LocalizedEnumValue {
  private String key;

  private String label;

  private List<LocalizedString> labelAllLocales;

  public LocalizedEnumValue() {
  }

  public LocalizedEnumValue(String key, String label, List<LocalizedString> labelAllLocales) {
    this.key = key;
    this.label = label;
    this.labelAllLocales = labelAllLocales;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public List<LocalizedString> getLabelAllLocales() {
    return labelAllLocales;
  }

  public void setLabelAllLocales(List<LocalizedString> labelAllLocales) {
    this.labelAllLocales = labelAllLocales;
  }

  @Override
  public String toString() {
    return "LocalizedEnumValue{key='" + key + "', label='" + label + "', labelAllLocales='" + labelAllLocales + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LocalizedEnumValue that = (LocalizedEnumValue) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(label, that.label) &&
        Objects.equals(labelAllLocales, that.labelAllLocales);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, label, labelAllLocales);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String label;

    private List<LocalizedString> labelAllLocales;

    public LocalizedEnumValue build() {
      LocalizedEnumValue result = new LocalizedEnumValue();
      result.key = this.key;
      result.label = this.label;
      result.labelAllLocales = this.labelAllLocales;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder label(String label) {
      this.label = label;
      return this;
    }

    public Builder labelAllLocales(List<LocalizedString> labelAllLocales) {
      this.labelAllLocales = labelAllLocales;
      return this;
    }
  }
}
