package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class LocalizedEnumValueDraft {
  private String key;

  private List<LocalizedStringItemInputType> label;

  public LocalizedEnumValueDraft() {
  }

  public LocalizedEnumValueDraft(String key, List<LocalizedStringItemInputType> label) {
    this.key = key;
    this.label = label;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<LocalizedStringItemInputType> getLabel() {
    return label;
  }

  public void setLabel(List<LocalizedStringItemInputType> label) {
    this.label = label;
  }

  @Override
  public String toString() {
    return "LocalizedEnumValueDraft{key='" + key + "', label='" + label + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LocalizedEnumValueDraft that = (LocalizedEnumValueDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(label, that.label);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, label);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private List<LocalizedStringItemInputType> label;

    public LocalizedEnumValueDraft build() {
      LocalizedEnumValueDraft result = new LocalizedEnumValueDraft();
      result.key = this.key;
      result.label = this.label;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder label(List<LocalizedStringItemInputType> label) {
      this.label = label;
      return this;
    }
  }
}
