package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class LocalizedEnumValueInput {
  private String key;

  private List<LocalizedStringItemInputType> label;

  public LocalizedEnumValueInput() {
  }

  public LocalizedEnumValueInput(String key, List<LocalizedStringItemInputType> label) {
    this.key = key;
    this.label = label;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<LocalizedStringItemInputType> getLabel() {
    return label;
  }

  public void setLabel(List<LocalizedStringItemInputType> label) {
    this.label = label;
  }

  @Override
  public String toString() {
    return "LocalizedEnumValueInput{key='" + key + "', label='" + label + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LocalizedEnumValueInput that = (LocalizedEnumValueInput) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(label, that.label);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, label);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private List<LocalizedStringItemInputType> label;

    public LocalizedEnumValueInput build() {
      LocalizedEnumValueInput result = new LocalizedEnumValueInput();
      result.key = this.key;
      result.label = this.label;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder label(List<LocalizedStringItemInputType> label) {
      this.label = label;
      return this;
    }
  }
}
