package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class Location {
  private String country;

  private String state;

  public Location() {
  }

  public Location(String country, String state) {
    this.country = country;
    this.state = state;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  @Override
  public String toString() {
    return "Location{country='" + country + "', state='" + state + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Location that = (Location) o;
    return Objects.equals(country, that.country) &&
        Objects.equals(state, that.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(country, state);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String country;

    private String state;

    public Location build() {
      Location result = new Location();
      result.country = this.country;
      result.state = this.state;
      return result;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder state(String state) {
      this.state = state;
      return this;
    }
  }
}
