package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class Me implements com.commercetools.graphql.api.types.MeQueryInterface, com.commercetools.graphql.api.types.CartQueryInterface, com.commercetools.graphql.api.types.ActiveCartInterface, com.commercetools.graphql.api.types.OrderQueryInterface, com.commercetools.graphql.api.types.ShoppingListQueryInterface {
  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private Customer customer;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private Cart cart;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private CartQueryResult carts;

  private Cart activeCart;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private Order order;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private OrderQueryResult orders;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private ShoppingList shoppingList;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private ShoppingListQueryResult shoppingLists;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private MyPayment payment;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private MyPaymentQueryResult payments;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private QuoteRequest quoteRequest;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private QuoteRequestQueryResult quoteRequests;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private Quote quote;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private QuoteQueryResult quotes;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private BusinessUnit businessUnit;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private BusinessUnitQueryResult businessUnits;

  public Me() {
  }

  public Me(Customer customer, Cart cart, CartQueryResult carts, Cart activeCart, Order order,
      OrderQueryResult orders, ShoppingList shoppingList, ShoppingListQueryResult shoppingLists,
      MyPayment payment, MyPaymentQueryResult payments, QuoteRequest quoteRequest,
      QuoteRequestQueryResult quoteRequests, Quote quote, QuoteQueryResult quotes,
      BusinessUnit businessUnit, BusinessUnitQueryResult businessUnits) {
    this.customer = customer;
    this.cart = cart;
    this.carts = carts;
    this.activeCart = activeCart;
    this.order = order;
    this.orders = orders;
    this.shoppingList = shoppingList;
    this.shoppingLists = shoppingLists;
    this.payment = payment;
    this.payments = payments;
    this.quoteRequest = quoteRequest;
    this.quoteRequests = quoteRequests;
    this.quote = quote;
    this.quotes = quotes;
    this.businessUnit = businessUnit;
    this.businessUnits = businessUnits;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public Cart getCart() {
    return cart;
  }

  public void setCart(Cart cart) {
    this.cart = cart;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public CartQueryResult getCarts() {
    return carts;
  }

  public void setCarts(CartQueryResult carts) {
    this.carts = carts;
  }

  public Cart getActiveCart() {
    return activeCart;
  }

  public void setActiveCart(Cart activeCart) {
    this.activeCart = activeCart;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public Order getOrder() {
    return order;
  }

  public void setOrder(Order order) {
    this.order = order;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public OrderQueryResult getOrders() {
    return orders;
  }

  public void setOrders(OrderQueryResult orders) {
    this.orders = orders;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public ShoppingList getShoppingList() {
    return shoppingList;
  }

  public void setShoppingList(ShoppingList shoppingList) {
    this.shoppingList = shoppingList;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public ShoppingListQueryResult getShoppingLists() {
    return shoppingLists;
  }

  public void setShoppingLists(ShoppingListQueryResult shoppingLists) {
    this.shoppingLists = shoppingLists;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public MyPayment getPayment() {
    return payment;
  }

  public void setPayment(MyPayment payment) {
    this.payment = payment;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public MyPaymentQueryResult getPayments() {
    return payments;
  }

  public void setPayments(MyPaymentQueryResult payments) {
    this.payments = payments;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public QuoteRequest getQuoteRequest() {
    return quoteRequest;
  }

  public void setQuoteRequest(QuoteRequest quoteRequest) {
    this.quoteRequest = quoteRequest;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public QuoteRequestQueryResult getQuoteRequests() {
    return quoteRequests;
  }

  public void setQuoteRequests(QuoteRequestQueryResult quoteRequests) {
    this.quoteRequests = quoteRequests;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public Quote getQuote() {
    return quote;
  }

  public void setQuote(Quote quote) {
    this.quote = quote;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public QuoteQueryResult getQuotes() {
    return quotes;
  }

  public void setQuotes(QuoteQueryResult quotes) {
    this.quotes = quotes;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public BusinessUnit getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(BusinessUnit businessUnit) {
    this.businessUnit = businessUnit;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public BusinessUnitQueryResult getBusinessUnits() {
    return businessUnits;
  }

  public void setBusinessUnits(BusinessUnitQueryResult businessUnits) {
    this.businessUnits = businessUnits;
  }

  @Override
  public String toString() {
    return "Me{customer='" + customer + "', cart='" + cart + "', carts='" + carts + "', activeCart='" + activeCart + "', order='" + order + "', orders='" + orders + "', shoppingList='" + shoppingList + "', shoppingLists='" + shoppingLists + "', payment='" + payment + "', payments='" + payments + "', quoteRequest='" + quoteRequest + "', quoteRequests='" + quoteRequests + "', quote='" + quote + "', quotes='" + quotes + "', businessUnit='" + businessUnit + "', businessUnits='" + businessUnits + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Me that = (Me) o;
    return Objects.equals(customer, that.customer) &&
        Objects.equals(cart, that.cart) &&
        Objects.equals(carts, that.carts) &&
        Objects.equals(activeCart, that.activeCart) &&
        Objects.equals(order, that.order) &&
        Objects.equals(orders, that.orders) &&
        Objects.equals(shoppingList, that.shoppingList) &&
        Objects.equals(shoppingLists, that.shoppingLists) &&
        Objects.equals(payment, that.payment) &&
        Objects.equals(payments, that.payments) &&
        Objects.equals(quoteRequest, that.quoteRequest) &&
        Objects.equals(quoteRequests, that.quoteRequests) &&
        Objects.equals(quote, that.quote) &&
        Objects.equals(quotes, that.quotes) &&
        Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(businessUnits, that.businessUnits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customer, cart, carts, activeCart, order, orders, shoppingList, shoppingLists, payment, payments, quoteRequest, quoteRequests, quote, quotes, businessUnit, businessUnits);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private Customer customer;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private Cart cart;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private CartQueryResult carts;

    private Cart activeCart;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private Order order;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private OrderQueryResult orders;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private ShoppingList shoppingList;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private ShoppingListQueryResult shoppingLists;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private MyPayment payment;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private MyPaymentQueryResult payments;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private QuoteRequest quoteRequest;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private QuoteRequestQueryResult quoteRequests;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private Quote quote;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private QuoteQueryResult quotes;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private BusinessUnit businessUnit;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private BusinessUnitQueryResult businessUnits;

    public Me build() {
      Me result = new Me();
      result.customer = this.customer;
      result.cart = this.cart;
      result.carts = this.carts;
      result.activeCart = this.activeCart;
      result.order = this.order;
      result.orders = this.orders;
      result.shoppingList = this.shoppingList;
      result.shoppingLists = this.shoppingLists;
      result.payment = this.payment;
      result.payments = this.payments;
      result.quoteRequest = this.quoteRequest;
      result.quoteRequests = this.quoteRequests;
      result.quote = this.quote;
      result.quotes = this.quotes;
      result.businessUnit = this.businessUnit;
      result.businessUnits = this.businessUnits;
      return result;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder cart(Cart cart) {
      this.cart = cart;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder carts(CartQueryResult carts) {
      this.carts = carts;
      return this;
    }

    public Builder activeCart(Cart activeCart) {
      this.activeCart = activeCart;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder order(Order order) {
      this.order = order;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder orders(OrderQueryResult orders) {
      this.orders = orders;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder shoppingList(ShoppingList shoppingList) {
      this.shoppingList = shoppingList;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder shoppingLists(ShoppingListQueryResult shoppingLists) {
      this.shoppingLists = shoppingLists;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder payment(MyPayment payment) {
      this.payment = payment;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder payments(MyPaymentQueryResult payments) {
      this.payments = payments;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder quoteRequest(QuoteRequest quoteRequest) {
      this.quoteRequest = quoteRequest;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder quoteRequests(QuoteRequestQueryResult quoteRequests) {
      this.quoteRequests = quoteRequests;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder quote(Quote quote) {
      this.quote = quote;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder quotes(QuoteQueryResult quotes) {
      this.quotes = quotes;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder businessUnit(BusinessUnit businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder businessUnits(BusinessUnitQueryResult businessUnits) {
      this.businessUnits = businessUnits;
      return this;
    }
  }
}
