package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = InStoreMe.class, name = "InStoreMe"),
    @JsonSubTypes.Type(value = Me.class, name = "Me")
})
public interface MeQueryInterface extends CartQueryInterface, ActiveCartInterface, OrderQueryInterface, ShoppingListQueryInterface {
  Cart getCart();

  void setCart(Cart cart);

  CartQueryResult getCarts();

  void setCarts(CartQueryResult carts);

  Cart getActiveCart();

  void setActiveCart(Cart activeCart);

  Order getOrder();

  void setOrder(Order order);

  OrderQueryResult getOrders();

  void setOrders(OrderQueryResult orders);

  ShoppingList getShoppingList();

  void setShoppingList(ShoppingList shoppingList);

  ShoppingListQueryResult getShoppingLists();

  void setShoppingLists(ShoppingListQueryResult shoppingLists);
}
