package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MessagesConfigurationDraft {
  private Boolean enabled;

  private Integer deleteDaysAfterCreation;

  public MessagesConfigurationDraft() {
  }

  public MessagesConfigurationDraft(Boolean enabled, Integer deleteDaysAfterCreation) {
    this.enabled = enabled;
    this.deleteDaysAfterCreation = deleteDaysAfterCreation;
  }

  public Boolean getEnabled() {
    return enabled;
  }

  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }

  public Integer getDeleteDaysAfterCreation() {
    return deleteDaysAfterCreation;
  }

  public void setDeleteDaysAfterCreation(Integer deleteDaysAfterCreation) {
    this.deleteDaysAfterCreation = deleteDaysAfterCreation;
  }

  @Override
  public String toString() {
    return "MessagesConfigurationDraft{enabled='" + enabled + "', deleteDaysAfterCreation='" + deleteDaysAfterCreation + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessagesConfigurationDraft that = (MessagesConfigurationDraft) o;
    return Objects.equals(enabled, that.enabled) &&
        Objects.equals(deleteDaysAfterCreation, that.deleteDaysAfterCreation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enabled, deleteDaysAfterCreation);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean enabled;

    private Integer deleteDaysAfterCreation;

    public MessagesConfigurationDraft build() {
      MessagesConfigurationDraft result = new MessagesConfigurationDraft();
      result.enabled = this.enabled;
      result.deleteDaysAfterCreation = this.deleteDaysAfterCreation;
      return result;
    }

    public Builder enabled(Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    public Builder deleteDaysAfterCreation(Integer deleteDaysAfterCreation) {
      this.deleteDaysAfterCreation = deleteDaysAfterCreation;
      return this;
    }
  }
}
