package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MethodExternalTaxRateDraft {
  private String shippingMethodKey;

  private ExternalTaxRateDraft taxRate;

  public MethodExternalTaxRateDraft() {
  }

  public MethodExternalTaxRateDraft(String shippingMethodKey, ExternalTaxRateDraft taxRate) {
    this.shippingMethodKey = shippingMethodKey;
    this.taxRate = taxRate;
  }

  public String getShippingMethodKey() {
    return shippingMethodKey;
  }

  public void setShippingMethodKey(String shippingMethodKey) {
    this.shippingMethodKey = shippingMethodKey;
  }

  public ExternalTaxRateDraft getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(ExternalTaxRateDraft taxRate) {
    this.taxRate = taxRate;
  }

  @Override
  public String toString() {
    return "MethodExternalTaxRateDraft{shippingMethodKey='" + shippingMethodKey + "', taxRate='" + taxRate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MethodExternalTaxRateDraft that = (MethodExternalTaxRateDraft) o;
    return Objects.equals(shippingMethodKey, that.shippingMethodKey) &&
        Objects.equals(taxRate, that.taxRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingMethodKey, taxRate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String shippingMethodKey;

    private ExternalTaxRateDraft taxRate;

    public MethodExternalTaxRateDraft build() {
      MethodExternalTaxRateDraft result = new MethodExternalTaxRateDraft();
      result.shippingMethodKey = this.shippingMethodKey;
      result.taxRate = this.taxRate;
      return result;
    }

    public Builder shippingMethodKey(String shippingMethodKey) {
      this.shippingMethodKey = shippingMethodKey;
      return this;
    }

    public Builder taxRate(ExternalTaxRateDraft taxRate) {
      this.taxRate = taxRate;
      return this;
    }
  }
}
