package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MethodTaxedPrice {
  private String shippingMethodKey;

  private TaxedItemPrice taxedPrice;

  public MethodTaxedPrice() {
  }

  public MethodTaxedPrice(String shippingMethodKey, TaxedItemPrice taxedPrice) {
    this.shippingMethodKey = shippingMethodKey;
    this.taxedPrice = taxedPrice;
  }

  public String getShippingMethodKey() {
    return shippingMethodKey;
  }

  public void setShippingMethodKey(String shippingMethodKey) {
    this.shippingMethodKey = shippingMethodKey;
  }

  public TaxedItemPrice getTaxedPrice() {
    return taxedPrice;
  }

  public void setTaxedPrice(TaxedItemPrice taxedPrice) {
    this.taxedPrice = taxedPrice;
  }

  @Override
  public String toString() {
    return "MethodTaxedPrice{shippingMethodKey='" + shippingMethodKey + "', taxedPrice='" + taxedPrice + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MethodTaxedPrice that = (MethodTaxedPrice) o;
    return Objects.equals(shippingMethodKey, that.shippingMethodKey) &&
        Objects.equals(taxedPrice, that.taxedPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingMethodKey, taxedPrice);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String shippingMethodKey;

    private TaxedItemPrice taxedPrice;

    public MethodTaxedPrice build() {
      MethodTaxedPrice result = new MethodTaxedPrice();
      result.shippingMethodKey = this.shippingMethodKey;
      result.taxedPrice = this.taxedPrice;
      return result;
    }

    public Builder shippingMethodKey(String shippingMethodKey) {
      this.shippingMethodKey = shippingMethodKey;
      return this;
    }

    public Builder taxedPrice(TaxedItemPrice taxedPrice) {
      this.taxedPrice = taxedPrice;
      return this;
    }
  }
}
