package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Currency;
import java.util.Objects;

public class MoneyInput {
  private Currency currencyCode;

  private Long centAmount;

  public MoneyInput() {
  }

  public MoneyInput(Currency currencyCode, Long centAmount) {
    this.currencyCode = currencyCode;
    this.centAmount = centAmount;
  }

  public Currency getCurrencyCode() {
    return currencyCode;
  }

  public void setCurrencyCode(Currency currencyCode) {
    this.currencyCode = currencyCode;
  }

  public Long getCentAmount() {
    return centAmount;
  }

  public void setCentAmount(Long centAmount) {
    this.centAmount = centAmount;
  }

  @Override
  public String toString() {
    return "MoneyInput{currencyCode='" + currencyCode + "', centAmount='" + centAmount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MoneyInput that = (MoneyInput) o;
    return Objects.equals(currencyCode, that.currencyCode) &&
        Objects.equals(centAmount, that.centAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currencyCode, centAmount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Currency currencyCode;

    private Long centAmount;

    public MoneyInput build() {
      MoneyInput result = new MoneyInput();
      result.currencyCode = this.currencyCode;
      result.centAmount = this.centAmount;
      return result;
    }

    public Builder currencyCode(Currency currencyCode) {
      this.currencyCode = currencyCode;
      return this;
    }

    public Builder centAmount(Long centAmount) {
      this.centAmount = centAmount;
      return this;
    }
  }
}
