package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MultiBuyLineItemsTargetInput {
  private String predicate;

  private Long triggerQuantity;

  private Long discountedQuantity;

  private Integer maxOccurrence;

  private SelectionMode selectionMode;

  public MultiBuyLineItemsTargetInput() {
  }

  public MultiBuyLineItemsTargetInput(String predicate, Long triggerQuantity,
      Long discountedQuantity, Integer maxOccurrence, SelectionMode selectionMode) {
    this.predicate = predicate;
    this.triggerQuantity = triggerQuantity;
    this.discountedQuantity = discountedQuantity;
    this.maxOccurrence = maxOccurrence;
    this.selectionMode = selectionMode;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  public Long getTriggerQuantity() {
    return triggerQuantity;
  }

  public void setTriggerQuantity(Long triggerQuantity) {
    this.triggerQuantity = triggerQuantity;
  }

  public Long getDiscountedQuantity() {
    return discountedQuantity;
  }

  public void setDiscountedQuantity(Long discountedQuantity) {
    this.discountedQuantity = discountedQuantity;
  }

  public Integer getMaxOccurrence() {
    return maxOccurrence;
  }

  public void setMaxOccurrence(Integer maxOccurrence) {
    this.maxOccurrence = maxOccurrence;
  }

  public SelectionMode getSelectionMode() {
    return selectionMode;
  }

  public void setSelectionMode(SelectionMode selectionMode) {
    this.selectionMode = selectionMode;
  }

  @Override
  public String toString() {
    return "MultiBuyLineItemsTargetInput{predicate='" + predicate + "', triggerQuantity='" + triggerQuantity + "', discountedQuantity='" + discountedQuantity + "', maxOccurrence='" + maxOccurrence + "', selectionMode='" + selectionMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MultiBuyLineItemsTargetInput that = (MultiBuyLineItemsTargetInput) o;
    return Objects.equals(predicate, that.predicate) &&
        Objects.equals(triggerQuantity, that.triggerQuantity) &&
        Objects.equals(discountedQuantity, that.discountedQuantity) &&
        Objects.equals(maxOccurrence, that.maxOccurrence) &&
        Objects.equals(selectionMode, that.selectionMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(predicate, triggerQuantity, discountedQuantity, maxOccurrence, selectionMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String predicate;

    private Long triggerQuantity;

    private Long discountedQuantity;

    private Integer maxOccurrence;

    private SelectionMode selectionMode;

    public MultiBuyLineItemsTargetInput build() {
      MultiBuyLineItemsTargetInput result = new MultiBuyLineItemsTargetInput();
      result.predicate = this.predicate;
      result.triggerQuantity = this.triggerQuantity;
      result.discountedQuantity = this.discountedQuantity;
      result.maxOccurrence = this.maxOccurrence;
      result.selectionMode = this.selectionMode;
      return result;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }

    public Builder triggerQuantity(Long triggerQuantity) {
      this.triggerQuantity = triggerQuantity;
      return this;
    }

    public Builder discountedQuantity(Long discountedQuantity) {
      this.discountedQuantity = discountedQuantity;
      return this;
    }

    public Builder maxOccurrence(Integer maxOccurrence) {
      this.maxOccurrence = maxOccurrence;
      return this;
    }

    public Builder selectionMode(SelectionMode selectionMode) {
      this.selectionMode = selectionMode;
      return this;
    }
  }
}
