package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

/**
 * My Payments endpoint provides access to payments scoped to a specific user.
 * [documentation](https://docs.commercetools.com/api/projects/me-payments#mypayment)
 */
public class MyPayment {
  private String id;

  private Long version;

  private Reference customerRef;

  private Customer customer;

  private String anonymousId;

  private PaymentMethodInfo paymentMethodInfo;

  private Money amountPlanned;

  private List<Transaction> transactions;

  private CustomFieldsType custom;

  public MyPayment() {
  }

  public MyPayment(String id, Long version, Reference customerRef, Customer customer,
      String anonymousId, PaymentMethodInfo paymentMethodInfo, Money amountPlanned,
      List<Transaction> transactions, CustomFieldsType custom) {
    this.id = id;
    this.version = version;
    this.customerRef = customerRef;
    this.customer = customer;
    this.anonymousId = anonymousId;
    this.paymentMethodInfo = paymentMethodInfo;
    this.amountPlanned = amountPlanned;
    this.transactions = transactions;
    this.custom = custom;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public Reference getCustomerRef() {
    return customerRef;
  }

  public void setCustomerRef(Reference customerRef) {
    this.customerRef = customerRef;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  public String getAnonymousId() {
    return anonymousId;
  }

  public void setAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  public PaymentMethodInfo getPaymentMethodInfo() {
    return paymentMethodInfo;
  }

  public void setPaymentMethodInfo(PaymentMethodInfo paymentMethodInfo) {
    this.paymentMethodInfo = paymentMethodInfo;
  }

  public Money getAmountPlanned() {
    return amountPlanned;
  }

  public void setAmountPlanned(Money amountPlanned) {
    this.amountPlanned = amountPlanned;
  }

  public List<Transaction> getTransactions() {
    return transactions;
  }

  public void setTransactions(List<Transaction> transactions) {
    this.transactions = transactions;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "MyPayment{id='" + id + "', version='" + version + "', customerRef='" + customerRef + "', customer='" + customer + "', anonymousId='" + anonymousId + "', paymentMethodInfo='" + paymentMethodInfo + "', amountPlanned='" + amountPlanned + "', transactions='" + transactions + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MyPayment that = (MyPayment) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(customerRef, that.customerRef) &&
        Objects.equals(customer, that.customer) &&
        Objects.equals(anonymousId, that.anonymousId) &&
        Objects.equals(paymentMethodInfo, that.paymentMethodInfo) &&
        Objects.equals(amountPlanned, that.amountPlanned) &&
        Objects.equals(transactions, that.transactions) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, version, customerRef, customer, anonymousId, paymentMethodInfo, amountPlanned, transactions, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private Long version;

    private Reference customerRef;

    private Customer customer;

    private String anonymousId;

    private PaymentMethodInfo paymentMethodInfo;

    private Money amountPlanned;

    private List<Transaction> transactions;

    private CustomFieldsType custom;

    public MyPayment build() {
      MyPayment result = new MyPayment();
      result.id = this.id;
      result.version = this.version;
      result.customerRef = this.customerRef;
      result.customer = this.customer;
      result.anonymousId = this.anonymousId;
      result.paymentMethodInfo = this.paymentMethodInfo;
      result.amountPlanned = this.amountPlanned;
      result.transactions = this.transactions;
      result.custom = this.custom;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder customerRef(Reference customerRef) {
      this.customerRef = customerRef;
      return this;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    public Builder anonymousId(String anonymousId) {
      this.anonymousId = anonymousId;
      return this;
    }

    public Builder paymentMethodInfo(PaymentMethodInfo paymentMethodInfo) {
      this.paymentMethodInfo = paymentMethodInfo;
      return this;
    }

    public Builder amountPlanned(Money amountPlanned) {
      this.amountPlanned = amountPlanned;
      return this;
    }

    public Builder transactions(List<Transaction> transactions) {
      this.transactions = transactions;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }
  }
}
