package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MyQuoteRequestDraft {
  private String cartId;

  private String comment;

  private Long cartVersion;

  public MyQuoteRequestDraft() {
  }

  public MyQuoteRequestDraft(String cartId, String comment, Long cartVersion) {
    this.cartId = cartId;
    this.comment = comment;
    this.cartVersion = cartVersion;
  }

  public String getCartId() {
    return cartId;
  }

  public void setCartId(String cartId) {
    this.cartId = cartId;
  }

  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public Long getCartVersion() {
    return cartVersion;
  }

  public void setCartVersion(Long cartVersion) {
    this.cartVersion = cartVersion;
  }

  @Override
  public String toString() {
    return "MyQuoteRequestDraft{cartId='" + cartId + "', comment='" + comment + "', cartVersion='" + cartVersion + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MyQuoteRequestDraft that = (MyQuoteRequestDraft) o;
    return Objects.equals(cartId, that.cartId) &&
        Objects.equals(comment, that.comment) &&
        Objects.equals(cartVersion, that.cartVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cartId, comment, cartVersion);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String cartId;

    private String comment;

    private Long cartVersion;

    public MyQuoteRequestDraft build() {
      MyQuoteRequestDraft result = new MyQuoteRequestDraft();
      result.cartId = this.cartId;
      result.comment = this.comment;
      result.cartVersion = this.cartVersion;
      return result;
    }

    public Builder cartId(String cartId) {
      this.cartId = cartId;
      return this;
    }

    public Builder comment(String comment) {
      this.comment = comment;
      return this;
    }

    public Builder cartVersion(Long cartVersion) {
      this.cartVersion = cartVersion;
      return this;
    }
  }
}
