package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MyShoppingListUpdateAction {
  private AddShoppingListLineItem addLineItem;

  private AddShoppingListTextLineItem addTextLineItem;

  private ChangeShoppingListLineItemQuantity changeLineItemQuantity;

  private ChangeShoppingListLineItemsOrder changeLineItemsOrder;

  private ChangeShoppingListName changeName;

  private ChangeShoppingListTextLineItemName changeTextLineItemName;

  private ChangeShoppingListTextLineItemQuantity changeTextLineItemQuantity;

  private ChangeShoppingListTextLineItemsOrder changeTextLineItemsOrder;

  private RemoveShoppingListLineItem removeLineItem;

  private RemoveShoppingListTextLineItem removeTextLineItem;

  private SetShoppingListCustomField setCustomField;

  private SetShoppingListCustomType setCustomType;

  private SetShoppingListDeleteDaysAfterLastModification setDeleteDaysAfterLastModification;

  private SetShoppingListDescription setDescription;

  private SetShoppingListLineItemCustomField setLineItemCustomField;

  private SetShoppingListLineItemCustomType setLineItemCustomType;

  private SetShoppingListStore setStore;

  private SetShoppingListTextLineItemCustomField setTextLineItemCustomField;

  private SetShoppingListTextLineItemCustomType setTextLineItemCustomType;

  private SetShoppingListTextLineItemDescription setTextLineItemDescription;

  public MyShoppingListUpdateAction() {
  }

  public MyShoppingListUpdateAction(AddShoppingListLineItem addLineItem,
      AddShoppingListTextLineItem addTextLineItem,
      ChangeShoppingListLineItemQuantity changeLineItemQuantity,
      ChangeShoppingListLineItemsOrder changeLineItemsOrder, ChangeShoppingListName changeName,
      ChangeShoppingListTextLineItemName changeTextLineItemName,
      ChangeShoppingListTextLineItemQuantity changeTextLineItemQuantity,
      ChangeShoppingListTextLineItemsOrder changeTextLineItemsOrder,
      RemoveShoppingListLineItem removeLineItem, RemoveShoppingListTextLineItem removeTextLineItem,
      SetShoppingListCustomField setCustomField, SetShoppingListCustomType setCustomType,
      SetShoppingListDeleteDaysAfterLastModification setDeleteDaysAfterLastModification,
      SetShoppingListDescription setDescription,
      SetShoppingListLineItemCustomField setLineItemCustomField,
      SetShoppingListLineItemCustomType setLineItemCustomType, SetShoppingListStore setStore,
      SetShoppingListTextLineItemCustomField setTextLineItemCustomField,
      SetShoppingListTextLineItemCustomType setTextLineItemCustomType,
      SetShoppingListTextLineItemDescription setTextLineItemDescription) {
    this.addLineItem = addLineItem;
    this.addTextLineItem = addTextLineItem;
    this.changeLineItemQuantity = changeLineItemQuantity;
    this.changeLineItemsOrder = changeLineItemsOrder;
    this.changeName = changeName;
    this.changeTextLineItemName = changeTextLineItemName;
    this.changeTextLineItemQuantity = changeTextLineItemQuantity;
    this.changeTextLineItemsOrder = changeTextLineItemsOrder;
    this.removeLineItem = removeLineItem;
    this.removeTextLineItem = removeTextLineItem;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setDeleteDaysAfterLastModification = setDeleteDaysAfterLastModification;
    this.setDescription = setDescription;
    this.setLineItemCustomField = setLineItemCustomField;
    this.setLineItemCustomType = setLineItemCustomType;
    this.setStore = setStore;
    this.setTextLineItemCustomField = setTextLineItemCustomField;
    this.setTextLineItemCustomType = setTextLineItemCustomType;
    this.setTextLineItemDescription = setTextLineItemDescription;
  }

  public AddShoppingListLineItem getAddLineItem() {
    return addLineItem;
  }

  public void setAddLineItem(AddShoppingListLineItem addLineItem) {
    this.addLineItem = addLineItem;
  }

  public AddShoppingListTextLineItem getAddTextLineItem() {
    return addTextLineItem;
  }

  public void setAddTextLineItem(AddShoppingListTextLineItem addTextLineItem) {
    this.addTextLineItem = addTextLineItem;
  }

  public ChangeShoppingListLineItemQuantity getChangeLineItemQuantity() {
    return changeLineItemQuantity;
  }

  public void setChangeLineItemQuantity(ChangeShoppingListLineItemQuantity changeLineItemQuantity) {
    this.changeLineItemQuantity = changeLineItemQuantity;
  }

  public ChangeShoppingListLineItemsOrder getChangeLineItemsOrder() {
    return changeLineItemsOrder;
  }

  public void setChangeLineItemsOrder(ChangeShoppingListLineItemsOrder changeLineItemsOrder) {
    this.changeLineItemsOrder = changeLineItemsOrder;
  }

  public ChangeShoppingListName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeShoppingListName changeName) {
    this.changeName = changeName;
  }

  public ChangeShoppingListTextLineItemName getChangeTextLineItemName() {
    return changeTextLineItemName;
  }

  public void setChangeTextLineItemName(ChangeShoppingListTextLineItemName changeTextLineItemName) {
    this.changeTextLineItemName = changeTextLineItemName;
  }

  public ChangeShoppingListTextLineItemQuantity getChangeTextLineItemQuantity() {
    return changeTextLineItemQuantity;
  }

  public void setChangeTextLineItemQuantity(
      ChangeShoppingListTextLineItemQuantity changeTextLineItemQuantity) {
    this.changeTextLineItemQuantity = changeTextLineItemQuantity;
  }

  public ChangeShoppingListTextLineItemsOrder getChangeTextLineItemsOrder() {
    return changeTextLineItemsOrder;
  }

  public void setChangeTextLineItemsOrder(
      ChangeShoppingListTextLineItemsOrder changeTextLineItemsOrder) {
    this.changeTextLineItemsOrder = changeTextLineItemsOrder;
  }

  public RemoveShoppingListLineItem getRemoveLineItem() {
    return removeLineItem;
  }

  public void setRemoveLineItem(RemoveShoppingListLineItem removeLineItem) {
    this.removeLineItem = removeLineItem;
  }

  public RemoveShoppingListTextLineItem getRemoveTextLineItem() {
    return removeTextLineItem;
  }

  public void setRemoveTextLineItem(RemoveShoppingListTextLineItem removeTextLineItem) {
    this.removeTextLineItem = removeTextLineItem;
  }

  public SetShoppingListCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetShoppingListCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetShoppingListCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetShoppingListCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetShoppingListDeleteDaysAfterLastModification getSetDeleteDaysAfterLastModification() {
    return setDeleteDaysAfterLastModification;
  }

  public void setSetDeleteDaysAfterLastModification(
      SetShoppingListDeleteDaysAfterLastModification setDeleteDaysAfterLastModification) {
    this.setDeleteDaysAfterLastModification = setDeleteDaysAfterLastModification;
  }

  public SetShoppingListDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetShoppingListDescription setDescription) {
    this.setDescription = setDescription;
  }

  public SetShoppingListLineItemCustomField getSetLineItemCustomField() {
    return setLineItemCustomField;
  }

  public void setSetLineItemCustomField(SetShoppingListLineItemCustomField setLineItemCustomField) {
    this.setLineItemCustomField = setLineItemCustomField;
  }

  public SetShoppingListLineItemCustomType getSetLineItemCustomType() {
    return setLineItemCustomType;
  }

  public void setSetLineItemCustomType(SetShoppingListLineItemCustomType setLineItemCustomType) {
    this.setLineItemCustomType = setLineItemCustomType;
  }

  public SetShoppingListStore getSetStore() {
    return setStore;
  }

  public void setSetStore(SetShoppingListStore setStore) {
    this.setStore = setStore;
  }

  public SetShoppingListTextLineItemCustomField getSetTextLineItemCustomField() {
    return setTextLineItemCustomField;
  }

  public void setSetTextLineItemCustomField(
      SetShoppingListTextLineItemCustomField setTextLineItemCustomField) {
    this.setTextLineItemCustomField = setTextLineItemCustomField;
  }

  public SetShoppingListTextLineItemCustomType getSetTextLineItemCustomType() {
    return setTextLineItemCustomType;
  }

  public void setSetTextLineItemCustomType(
      SetShoppingListTextLineItemCustomType setTextLineItemCustomType) {
    this.setTextLineItemCustomType = setTextLineItemCustomType;
  }

  public SetShoppingListTextLineItemDescription getSetTextLineItemDescription() {
    return setTextLineItemDescription;
  }

  public void setSetTextLineItemDescription(
      SetShoppingListTextLineItemDescription setTextLineItemDescription) {
    this.setTextLineItemDescription = setTextLineItemDescription;
  }

  @Override
  public String toString() {
    return "MyShoppingListUpdateAction{addLineItem='" + addLineItem + "', addTextLineItem='" + addTextLineItem + "', changeLineItemQuantity='" + changeLineItemQuantity + "', changeLineItemsOrder='" + changeLineItemsOrder + "', changeName='" + changeName + "', changeTextLineItemName='" + changeTextLineItemName + "', changeTextLineItemQuantity='" + changeTextLineItemQuantity + "', changeTextLineItemsOrder='" + changeTextLineItemsOrder + "', removeLineItem='" + removeLineItem + "', removeTextLineItem='" + removeTextLineItem + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setDeleteDaysAfterLastModification='" + setDeleteDaysAfterLastModification + "', setDescription='" + setDescription + "', setLineItemCustomField='" + setLineItemCustomField + "', setLineItemCustomType='" + setLineItemCustomType + "', setStore='" + setStore + "', setTextLineItemCustomField='" + setTextLineItemCustomField + "', setTextLineItemCustomType='" + setTextLineItemCustomType + "', setTextLineItemDescription='" + setTextLineItemDescription + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MyShoppingListUpdateAction that = (MyShoppingListUpdateAction) o;
    return Objects.equals(addLineItem, that.addLineItem) &&
        Objects.equals(addTextLineItem, that.addTextLineItem) &&
        Objects.equals(changeLineItemQuantity, that.changeLineItemQuantity) &&
        Objects.equals(changeLineItemsOrder, that.changeLineItemsOrder) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(changeTextLineItemName, that.changeTextLineItemName) &&
        Objects.equals(changeTextLineItemQuantity, that.changeTextLineItemQuantity) &&
        Objects.equals(changeTextLineItemsOrder, that.changeTextLineItemsOrder) &&
        Objects.equals(removeLineItem, that.removeLineItem) &&
        Objects.equals(removeTextLineItem, that.removeTextLineItem) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setDeleteDaysAfterLastModification, that.setDeleteDaysAfterLastModification) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(setLineItemCustomField, that.setLineItemCustomField) &&
        Objects.equals(setLineItemCustomType, that.setLineItemCustomType) &&
        Objects.equals(setStore, that.setStore) &&
        Objects.equals(setTextLineItemCustomField, that.setTextLineItemCustomField) &&
        Objects.equals(setTextLineItemCustomType, that.setTextLineItemCustomType) &&
        Objects.equals(setTextLineItemDescription, that.setTextLineItemDescription);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addLineItem, addTextLineItem, changeLineItemQuantity, changeLineItemsOrder, changeName, changeTextLineItemName, changeTextLineItemQuantity, changeTextLineItemsOrder, removeLineItem, removeTextLineItem, setCustomField, setCustomType, setDeleteDaysAfterLastModification, setDescription, setLineItemCustomField, setLineItemCustomType, setStore, setTextLineItemCustomField, setTextLineItemCustomType, setTextLineItemDescription);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddShoppingListLineItem addLineItem;

    private AddShoppingListTextLineItem addTextLineItem;

    private ChangeShoppingListLineItemQuantity changeLineItemQuantity;

    private ChangeShoppingListLineItemsOrder changeLineItemsOrder;

    private ChangeShoppingListName changeName;

    private ChangeShoppingListTextLineItemName changeTextLineItemName;

    private ChangeShoppingListTextLineItemQuantity changeTextLineItemQuantity;

    private ChangeShoppingListTextLineItemsOrder changeTextLineItemsOrder;

    private RemoveShoppingListLineItem removeLineItem;

    private RemoveShoppingListTextLineItem removeTextLineItem;

    private SetShoppingListCustomField setCustomField;

    private SetShoppingListCustomType setCustomType;

    private SetShoppingListDeleteDaysAfterLastModification setDeleteDaysAfterLastModification;

    private SetShoppingListDescription setDescription;

    private SetShoppingListLineItemCustomField setLineItemCustomField;

    private SetShoppingListLineItemCustomType setLineItemCustomType;

    private SetShoppingListStore setStore;

    private SetShoppingListTextLineItemCustomField setTextLineItemCustomField;

    private SetShoppingListTextLineItemCustomType setTextLineItemCustomType;

    private SetShoppingListTextLineItemDescription setTextLineItemDescription;

    public MyShoppingListUpdateAction build() {
      MyShoppingListUpdateAction result = new MyShoppingListUpdateAction();
      result.addLineItem = this.addLineItem;
      result.addTextLineItem = this.addTextLineItem;
      result.changeLineItemQuantity = this.changeLineItemQuantity;
      result.changeLineItemsOrder = this.changeLineItemsOrder;
      result.changeName = this.changeName;
      result.changeTextLineItemName = this.changeTextLineItemName;
      result.changeTextLineItemQuantity = this.changeTextLineItemQuantity;
      result.changeTextLineItemsOrder = this.changeTextLineItemsOrder;
      result.removeLineItem = this.removeLineItem;
      result.removeTextLineItem = this.removeTextLineItem;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setDeleteDaysAfterLastModification = this.setDeleteDaysAfterLastModification;
      result.setDescription = this.setDescription;
      result.setLineItemCustomField = this.setLineItemCustomField;
      result.setLineItemCustomType = this.setLineItemCustomType;
      result.setStore = this.setStore;
      result.setTextLineItemCustomField = this.setTextLineItemCustomField;
      result.setTextLineItemCustomType = this.setTextLineItemCustomType;
      result.setTextLineItemDescription = this.setTextLineItemDescription;
      return result;
    }

    public Builder addLineItem(AddShoppingListLineItem addLineItem) {
      this.addLineItem = addLineItem;
      return this;
    }

    public Builder addTextLineItem(AddShoppingListTextLineItem addTextLineItem) {
      this.addTextLineItem = addTextLineItem;
      return this;
    }

    public Builder changeLineItemQuantity(
        ChangeShoppingListLineItemQuantity changeLineItemQuantity) {
      this.changeLineItemQuantity = changeLineItemQuantity;
      return this;
    }

    public Builder changeLineItemsOrder(ChangeShoppingListLineItemsOrder changeLineItemsOrder) {
      this.changeLineItemsOrder = changeLineItemsOrder;
      return this;
    }

    public Builder changeName(ChangeShoppingListName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder changeTextLineItemName(
        ChangeShoppingListTextLineItemName changeTextLineItemName) {
      this.changeTextLineItemName = changeTextLineItemName;
      return this;
    }

    public Builder changeTextLineItemQuantity(
        ChangeShoppingListTextLineItemQuantity changeTextLineItemQuantity) {
      this.changeTextLineItemQuantity = changeTextLineItemQuantity;
      return this;
    }

    public Builder changeTextLineItemsOrder(
        ChangeShoppingListTextLineItemsOrder changeTextLineItemsOrder) {
      this.changeTextLineItemsOrder = changeTextLineItemsOrder;
      return this;
    }

    public Builder removeLineItem(RemoveShoppingListLineItem removeLineItem) {
      this.removeLineItem = removeLineItem;
      return this;
    }

    public Builder removeTextLineItem(RemoveShoppingListTextLineItem removeTextLineItem) {
      this.removeTextLineItem = removeTextLineItem;
      return this;
    }

    public Builder setCustomField(SetShoppingListCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetShoppingListCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setDeleteDaysAfterLastModification(
        SetShoppingListDeleteDaysAfterLastModification setDeleteDaysAfterLastModification) {
      this.setDeleteDaysAfterLastModification = setDeleteDaysAfterLastModification;
      return this;
    }

    public Builder setDescription(SetShoppingListDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder setLineItemCustomField(
        SetShoppingListLineItemCustomField setLineItemCustomField) {
      this.setLineItemCustomField = setLineItemCustomField;
      return this;
    }

    public Builder setLineItemCustomType(SetShoppingListLineItemCustomType setLineItemCustomType) {
      this.setLineItemCustomType = setLineItemCustomType;
      return this;
    }

    public Builder setStore(SetShoppingListStore setStore) {
      this.setStore = setStore;
      return this;
    }

    public Builder setTextLineItemCustomField(
        SetShoppingListTextLineItemCustomField setTextLineItemCustomField) {
      this.setTextLineItemCustomField = setTextLineItemCustomField;
      return this;
    }

    public Builder setTextLineItemCustomType(
        SetShoppingListTextLineItemCustomType setTextLineItemCustomType) {
      this.setTextLineItemCustomType = setTextLineItemCustomType;
      return this;
    }

    public Builder setTextLineItemDescription(
        SetShoppingListTextLineItemDescription setTextLineItemDescription) {
      this.setTextLineItemDescription = setTextLineItemDescription;
      return this;
    }
  }
}
