package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class MyTransactionDraft {
  private OffsetDateTime timestamp;

  private TransactionType type;

  private MoneyInput amount;

  private String interactionId;

  private CustomFieldsDraft custom;

  public MyTransactionDraft() {
  }

  public MyTransactionDraft(OffsetDateTime timestamp, TransactionType type, MoneyInput amount,
      String interactionId, CustomFieldsDraft custom) {
    this.timestamp = timestamp;
    this.type = type;
    this.amount = amount;
    this.interactionId = interactionId;
    this.custom = custom;
  }

  public OffsetDateTime getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(OffsetDateTime timestamp) {
    this.timestamp = timestamp;
  }

  public TransactionType getType() {
    return type;
  }

  public void setType(TransactionType type) {
    this.type = type;
  }

  public MoneyInput getAmount() {
    return amount;
  }

  public void setAmount(MoneyInput amount) {
    this.amount = amount;
  }

  public String getInteractionId() {
    return interactionId;
  }

  public void setInteractionId(String interactionId) {
    this.interactionId = interactionId;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "MyTransactionDraft{timestamp='" + timestamp + "', type='" + type + "', amount='" + amount + "', interactionId='" + interactionId + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MyTransactionDraft that = (MyTransactionDraft) o;
    return Objects.equals(timestamp, that.timestamp) &&
        Objects.equals(type, that.type) &&
        Objects.equals(amount, that.amount) &&
        Objects.equals(interactionId, that.interactionId) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(timestamp, type, amount, interactionId, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime timestamp;

    private TransactionType type;

    private MoneyInput amount;

    private String interactionId;

    private CustomFieldsDraft custom;

    public MyTransactionDraft build() {
      MyTransactionDraft result = new MyTransactionDraft();
      result.timestamp = this.timestamp;
      result.type = this.type;
      result.amount = this.amount;
      result.interactionId = this.interactionId;
      result.custom = this.custom;
      return result;
    }

    public Builder timestamp(OffsetDateTime timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    public Builder type(TransactionType type) {
      this.type = type;
      return this;
    }

    public Builder amount(MoneyInput amount) {
      this.amount = amount;
      return this;
    }

    public Builder interactionId(String interactionId) {
      this.interactionId = interactionId;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
