package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class NestedAttributeDefinitionType implements com.commercetools.graphql.api.types.AttributeDefinitionType {
  private Reference typeRef;

  private String name;

  public NestedAttributeDefinitionType() {
  }

  public NestedAttributeDefinitionType(Reference typeRef, String name) {
    this.typeRef = typeRef;
    this.name = name;
  }

  public Reference getTypeRef() {
    return typeRef;
  }

  public void setTypeRef(Reference typeRef) {
    this.typeRef = typeRef;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "NestedAttributeDefinitionType{typeRef='" + typeRef + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NestedAttributeDefinitionType that = (NestedAttributeDefinitionType) o;
    return Objects.equals(typeRef, that.typeRef) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(typeRef, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference typeRef;

    private String name;

    public NestedAttributeDefinitionType build() {
      NestedAttributeDefinitionType result = new NestedAttributeDefinitionType();
      result.typeRef = this.typeRef;
      result.name = this.name;
      return result;
    }

    public Builder typeRef(Reference typeRef) {
      this.typeRef = typeRef;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
