package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class NumberAttribute implements com.commercetools.graphql.api.types.Attribute {
  private Double value;

  private String name;

  public NumberAttribute() {
  }

  public NumberAttribute(Double value, String name) {
    this.value = value;
    this.name = name;
  }

  public Double getValue() {
    return value;
  }

  public void setValue(Double value) {
    this.value = value;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "NumberAttribute{value='" + value + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NumberAttribute that = (NumberAttribute) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Double value;

    private String name;

    public NumberAttribute build() {
      NumberAttribute result = new NumberAttribute();
      result.value = this.value;
      result.name = this.name;
      return result;
    }

    public Builder value(Double value) {
      this.value = value;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
