package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderCustomLineItemDiscountSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String customLineItemId;

  private String customLineItemKey;

  private List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity;

  private TaxedItemPrice taxedPrice;

  private String type;

  public OrderCustomLineItemDiscountSet() {
  }

  public OrderCustomLineItemDiscountSet(String customLineItemId, String customLineItemKey,
      List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity,
      TaxedItemPrice taxedPrice, String type) {
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.discountedPricePerQuantity = discountedPricePerQuantity;
    this.taxedPrice = taxedPrice;
    this.type = type;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public List<DiscountedLineItemPriceForQuantity> getDiscountedPricePerQuantity() {
    return discountedPricePerQuantity;
  }

  public void setDiscountedPricePerQuantity(
      List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity) {
    this.discountedPricePerQuantity = discountedPricePerQuantity;
  }

  public TaxedItemPrice getTaxedPrice() {
    return taxedPrice;
  }

  public void setTaxedPrice(TaxedItemPrice taxedPrice) {
    this.taxedPrice = taxedPrice;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderCustomLineItemDiscountSet{customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', discountedPricePerQuantity='" + discountedPricePerQuantity + "', taxedPrice='" + taxedPrice + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderCustomLineItemDiscountSet that = (OrderCustomLineItemDiscountSet) o;
    return Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(discountedPricePerQuantity, that.discountedPricePerQuantity) &&
        Objects.equals(taxedPrice, that.taxedPrice) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItemId, customLineItemKey, discountedPricePerQuantity, taxedPrice, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customLineItemId;

    private String customLineItemKey;

    private List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity;

    private TaxedItemPrice taxedPrice;

    private String type;

    public OrderCustomLineItemDiscountSet build() {
      OrderCustomLineItemDiscountSet result = new OrderCustomLineItemDiscountSet();
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.discountedPricePerQuantity = this.discountedPricePerQuantity;
      result.taxedPrice = this.taxedPrice;
      result.type = this.type;
      return result;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder discountedPricePerQuantity(
        List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity) {
      this.discountedPricePerQuantity = discountedPricePerQuantity;
      return this;
    }

    public Builder taxedPrice(TaxedItemPrice taxedPrice) {
      this.taxedPrice = taxedPrice;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
