package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderCustomLineItemRemoved implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String customLineItemId;

  private String customLineItemKey;

  private CustomLineItem customLineItem;

  private String type;

  public OrderCustomLineItemRemoved() {
  }

  public OrderCustomLineItemRemoved(String customLineItemId, String customLineItemKey,
      CustomLineItem customLineItem, String type) {
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.customLineItem = customLineItem;
    this.type = type;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public CustomLineItem getCustomLineItem() {
    return customLineItem;
  }

  public void setCustomLineItem(CustomLineItem customLineItem) {
    this.customLineItem = customLineItem;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderCustomLineItemRemoved{customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', customLineItem='" + customLineItem + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderCustomLineItemRemoved that = (OrderCustomLineItemRemoved) o;
    return Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(customLineItem, that.customLineItem) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItemId, customLineItemKey, customLineItem, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customLineItemId;

    private String customLineItemKey;

    private CustomLineItem customLineItem;

    private String type;

    public OrderCustomLineItemRemoved build() {
      OrderCustomLineItemRemoved result = new OrderCustomLineItemRemoved();
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.customLineItem = this.customLineItem;
      result.type = this.type;
      return result;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder customLineItem(CustomLineItem customLineItem) {
      this.customLineItem = customLineItem;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
