package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderDeleted implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private Order order;

  private String type;

  public OrderDeleted() {
  }

  public OrderDeleted(Order order, String type) {
    this.order = order;
    this.type = type;
  }

  public Order getOrder() {
    return order;
  }

  public void setOrder(Order order) {
    this.order = order;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderDeleted{order='" + order + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderDeleted that = (OrderDeleted) o;
    return Objects.equals(order, that.order) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(order, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Order order;

    private String type;

    public OrderDeleted build() {
      OrderDeleted result = new OrderDeleted();
      result.order = this.order;
      result.type = this.type;
      return result;
    }

    public Builder order(Order order) {
      this.order = order;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
