package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderEdit implements com.commercetools.graphql.api.types.Versioned {
  private String key;

  private Reference resourceRef;

  private Order resource;

  private List<StagedOrderUpdateActionOutput> stagedActions;

  private OrderEditResult result;

  private String comment;

  private CustomFieldsType custom;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public OrderEdit() {
  }

  public OrderEdit(String key, Reference resourceRef, Order resource,
      List<StagedOrderUpdateActionOutput> stagedActions, OrderEditResult result, String comment,
      CustomFieldsType custom, String id, Long version, OffsetDateTime createdAt,
      OffsetDateTime lastModifiedAt, Initiator createdBy, Initiator lastModifiedBy) {
    this.key = key;
    this.resourceRef = resourceRef;
    this.resource = resource;
    this.stagedActions = stagedActions;
    this.result = result;
    this.comment = comment;
    this.custom = custom;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Reference getResourceRef() {
    return resourceRef;
  }

  public void setResourceRef(Reference resourceRef) {
    this.resourceRef = resourceRef;
  }

  public Order getResource() {
    return resource;
  }

  public void setResource(Order resource) {
    this.resource = resource;
  }

  public List<StagedOrderUpdateActionOutput> getStagedActions() {
    return stagedActions;
  }

  public void setStagedActions(List<StagedOrderUpdateActionOutput> stagedActions) {
    this.stagedActions = stagedActions;
  }

  public OrderEditResult getResult() {
    return result;
  }

  public void setResult(OrderEditResult result) {
    this.result = result;
  }

  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "OrderEdit{key='" + key + "', resourceRef='" + resourceRef + "', resource='" + resource + "', stagedActions='" + stagedActions + "', result='" + result + "', comment='" + comment + "', custom='" + custom + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderEdit that = (OrderEdit) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(resourceRef, that.resourceRef) &&
        Objects.equals(resource, that.resource) &&
        Objects.equals(stagedActions, that.stagedActions) &&
        Objects.equals(result, that.result) &&
        Objects.equals(comment, that.comment) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, resourceRef, resource, stagedActions, result, comment, custom, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private Reference resourceRef;

    private Order resource;

    private List<StagedOrderUpdateActionOutput> stagedActions;

    private OrderEditResult result;

    private String comment;

    private CustomFieldsType custom;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public OrderEdit build() {
      OrderEdit result = new OrderEdit();
      result.key = this.key;
      result.resourceRef = this.resourceRef;
      result.resource = this.resource;
      result.stagedActions = this.stagedActions;
      result.result = this.result;
      result.comment = this.comment;
      result.custom = this.custom;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder resourceRef(Reference resourceRef) {
      this.resourceRef = resourceRef;
      return this;
    }

    public Builder resource(Order resource) {
      this.resource = resource;
      return this;
    }

    public Builder stagedActions(List<StagedOrderUpdateActionOutput> stagedActions) {
      this.stagedActions = stagedActions;
      return this;
    }

    public Builder result(OrderEditResult result) {
      this.result = result;
      return this;
    }

    public Builder comment(String comment) {
      this.comment = comment;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
