package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderEditApplied implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private Applied result;

  private OrderEdit edit;

  private Reference editRef;

  private String type;

  public OrderEditApplied() {
  }

  public OrderEditApplied(Applied result, OrderEdit edit, Reference editRef, String type) {
    this.result = result;
    this.edit = edit;
    this.editRef = editRef;
    this.type = type;
  }

  public Applied getResult() {
    return result;
  }

  public void setResult(Applied result) {
    this.result = result;
  }

  public OrderEdit getEdit() {
    return edit;
  }

  public void setEdit(OrderEdit edit) {
    this.edit = edit;
  }

  public Reference getEditRef() {
    return editRef;
  }

  public void setEditRef(Reference editRef) {
    this.editRef = editRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderEditApplied{result='" + result + "', edit='" + edit + "', editRef='" + editRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderEditApplied that = (OrderEditApplied) o;
    return Objects.equals(result, that.result) &&
        Objects.equals(edit, that.edit) &&
        Objects.equals(editRef, that.editRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(result, edit, editRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Applied result;

    private OrderEdit edit;

    private Reference editRef;

    private String type;

    public OrderEditApplied build() {
      OrderEditApplied result = new OrderEditApplied();
      result.result = this.result;
      result.edit = this.edit;
      result.editRef = this.editRef;
      result.type = this.type;
      return result;
    }

    public Builder result(Applied result) {
      this.result = result;
      return this;
    }

    public Builder edit(OrderEdit edit) {
      this.edit = edit;
      return this;
    }

    public Builder editRef(Reference editRef) {
      this.editRef = editRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
