package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class OrderEditLimitsProjection {
  private OrderEditLimitWithCurrent total;

  public OrderEditLimitsProjection() {
  }

  public OrderEditLimitsProjection(OrderEditLimitWithCurrent total) {
    this.total = total;
  }

  public OrderEditLimitWithCurrent getTotal() {
    return total;
  }

  public void setTotal(OrderEditLimitWithCurrent total) {
    this.total = total;
  }

  @Override
  public String toString() {
    return "OrderEditLimitsProjection{total='" + total + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderEditLimitsProjection that = (OrderEditLimitsProjection) o;
    return Objects.equals(total, that.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OrderEditLimitWithCurrent total;

    public OrderEditLimitsProjection build() {
      OrderEditLimitsProjection result = new OrderEditLimitsProjection();
      result.total = this.total;
      return result;
    }

    public Builder total(OrderEditLimitWithCurrent total) {
      this.total = total;
      return this;
    }
  }
}
