package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class OrderEditUpdateAction {
  private AddOrderEditStagedAction addStagedAction;

  private SetOrderEditComment setComment;

  private SetOrderEditCustomField setCustomField;

  private SetOrderEditCustomType setCustomType;

  private SetOrderEditKey setKey;

  private SetOrderEditStagedActions setStagedActions;

  public OrderEditUpdateAction() {
  }

  public OrderEditUpdateAction(AddOrderEditStagedAction addStagedAction,
      SetOrderEditComment setComment, SetOrderEditCustomField setCustomField,
      SetOrderEditCustomType setCustomType, SetOrderEditKey setKey,
      SetOrderEditStagedActions setStagedActions) {
    this.addStagedAction = addStagedAction;
    this.setComment = setComment;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setKey = setKey;
    this.setStagedActions = setStagedActions;
  }

  public AddOrderEditStagedAction getAddStagedAction() {
    return addStagedAction;
  }

  public void setAddStagedAction(AddOrderEditStagedAction addStagedAction) {
    this.addStagedAction = addStagedAction;
  }

  public SetOrderEditComment getSetComment() {
    return setComment;
  }

  public void setSetComment(SetOrderEditComment setComment) {
    this.setComment = setComment;
  }

  public SetOrderEditCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetOrderEditCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetOrderEditCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetOrderEditCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetOrderEditKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetOrderEditKey setKey) {
    this.setKey = setKey;
  }

  public SetOrderEditStagedActions getSetStagedActions() {
    return setStagedActions;
  }

  public void setSetStagedActions(SetOrderEditStagedActions setStagedActions) {
    this.setStagedActions = setStagedActions;
  }

  @Override
  public String toString() {
    return "OrderEditUpdateAction{addStagedAction='" + addStagedAction + "', setComment='" + setComment + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setKey='" + setKey + "', setStagedActions='" + setStagedActions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderEditUpdateAction that = (OrderEditUpdateAction) o;
    return Objects.equals(addStagedAction, that.addStagedAction) &&
        Objects.equals(setComment, that.setComment) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setStagedActions, that.setStagedActions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addStagedAction, setComment, setCustomField, setCustomType, setKey, setStagedActions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddOrderEditStagedAction addStagedAction;

    private SetOrderEditComment setComment;

    private SetOrderEditCustomField setCustomField;

    private SetOrderEditCustomType setCustomType;

    private SetOrderEditKey setKey;

    private SetOrderEditStagedActions setStagedActions;

    public OrderEditUpdateAction build() {
      OrderEditUpdateAction result = new OrderEditUpdateAction();
      result.addStagedAction = this.addStagedAction;
      result.setComment = this.setComment;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setKey = this.setKey;
      result.setStagedActions = this.setStagedActions;
      return result;
    }

    public Builder addStagedAction(AddOrderEditStagedAction addStagedAction) {
      this.addStagedAction = addStagedAction;
      return this;
    }

    public Builder setComment(SetOrderEditComment setComment) {
      this.setComment = setComment;
      return this;
    }

    public Builder setCustomField(SetOrderEditCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetOrderEditCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setKey(SetOrderEditKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setStagedActions(SetOrderEditStagedActions setStagedActions) {
      this.setStagedActions = setStagedActions;
      return this;
    }
  }
}
