package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderLineItemRemoved implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String lineItemId;

  private String lineItemKey;

  private Long removedQuantity;

  private Long newQuantity;

  private Object newState;

  private Money newTotalPrice;

  private ProductPrice newPrice;

  private ItemShippingDetails newShippingDetails;

  private TaxedItemPrice newTaxedPrice;

  private String type;

  public OrderLineItemRemoved() {
  }

  public OrderLineItemRemoved(String lineItemId, String lineItemKey, Long removedQuantity,
      Long newQuantity, Object newState, Money newTotalPrice, ProductPrice newPrice,
      ItemShippingDetails newShippingDetails, TaxedItemPrice newTaxedPrice, String type) {
    this.lineItemId = lineItemId;
    this.lineItemKey = lineItemKey;
    this.removedQuantity = removedQuantity;
    this.newQuantity = newQuantity;
    this.newState = newState;
    this.newTotalPrice = newTotalPrice;
    this.newPrice = newPrice;
    this.newShippingDetails = newShippingDetails;
    this.newTaxedPrice = newTaxedPrice;
    this.type = type;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  public Long getRemovedQuantity() {
    return removedQuantity;
  }

  public void setRemovedQuantity(Long removedQuantity) {
    this.removedQuantity = removedQuantity;
  }

  public Long getNewQuantity() {
    return newQuantity;
  }

  public void setNewQuantity(Long newQuantity) {
    this.newQuantity = newQuantity;
  }

  public Object getNewState() {
    return newState;
  }

  public void setNewState(Object newState) {
    this.newState = newState;
  }

  public Money getNewTotalPrice() {
    return newTotalPrice;
  }

  public void setNewTotalPrice(Money newTotalPrice) {
    this.newTotalPrice = newTotalPrice;
  }

  public ProductPrice getNewPrice() {
    return newPrice;
  }

  public void setNewPrice(ProductPrice newPrice) {
    this.newPrice = newPrice;
  }

  public ItemShippingDetails getNewShippingDetails() {
    return newShippingDetails;
  }

  public void setNewShippingDetails(ItemShippingDetails newShippingDetails) {
    this.newShippingDetails = newShippingDetails;
  }

  public TaxedItemPrice getNewTaxedPrice() {
    return newTaxedPrice;
  }

  public void setNewTaxedPrice(TaxedItemPrice newTaxedPrice) {
    this.newTaxedPrice = newTaxedPrice;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderLineItemRemoved{lineItemId='" + lineItemId + "', lineItemKey='" + lineItemKey + "', removedQuantity='" + removedQuantity + "', newQuantity='" + newQuantity + "', newState='" + newState + "', newTotalPrice='" + newTotalPrice + "', newPrice='" + newPrice + "', newShippingDetails='" + newShippingDetails + "', newTaxedPrice='" + newTaxedPrice + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderLineItemRemoved that = (OrderLineItemRemoved) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(lineItemKey, that.lineItemKey) &&
        Objects.equals(removedQuantity, that.removedQuantity) &&
        Objects.equals(newQuantity, that.newQuantity) &&
        Objects.equals(newState, that.newState) &&
        Objects.equals(newTotalPrice, that.newTotalPrice) &&
        Objects.equals(newPrice, that.newPrice) &&
        Objects.equals(newShippingDetails, that.newShippingDetails) &&
        Objects.equals(newTaxedPrice, that.newTaxedPrice) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, lineItemKey, removedQuantity, newQuantity, newState, newTotalPrice, newPrice, newShippingDetails, newTaxedPrice, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private String lineItemKey;

    private Long removedQuantity;

    private Long newQuantity;

    private Object newState;

    private Money newTotalPrice;

    private ProductPrice newPrice;

    private ItemShippingDetails newShippingDetails;

    private TaxedItemPrice newTaxedPrice;

    private String type;

    public OrderLineItemRemoved build() {
      OrderLineItemRemoved result = new OrderLineItemRemoved();
      result.lineItemId = this.lineItemId;
      result.lineItemKey = this.lineItemKey;
      result.removedQuantity = this.removedQuantity;
      result.newQuantity = this.newQuantity;
      result.newState = this.newState;
      result.newTotalPrice = this.newTotalPrice;
      result.newPrice = this.newPrice;
      result.newShippingDetails = this.newShippingDetails;
      result.newTaxedPrice = this.newTaxedPrice;
      result.type = this.type;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }

    public Builder removedQuantity(Long removedQuantity) {
      this.removedQuantity = removedQuantity;
      return this;
    }

    public Builder newQuantity(Long newQuantity) {
      this.newQuantity = newQuantity;
      return this;
    }

    public Builder newState(Object newState) {
      this.newState = newState;
      return this;
    }

    public Builder newTotalPrice(Money newTotalPrice) {
      this.newTotalPrice = newTotalPrice;
      return this;
    }

    public Builder newPrice(ProductPrice newPrice) {
      this.newPrice = newPrice;
      return this;
    }

    public Builder newShippingDetails(ItemShippingDetails newShippingDetails) {
      this.newShippingDetails = newShippingDetails;
      return this;
    }

    public Builder newTaxedPrice(TaxedItemPrice newTaxedPrice) {
      this.newTaxedPrice = newTaxedPrice;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
