package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class OrderMyQuoteCommand {
  private String id;

  private Long version;

  private Boolean quoteStateToAccepted = false;

  public OrderMyQuoteCommand() {
  }

  public OrderMyQuoteCommand(String id, Long version, Boolean quoteStateToAccepted) {
    this.id = id;
    this.version = version;
    this.quoteStateToAccepted = quoteStateToAccepted;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public Boolean getQuoteStateToAccepted() {
    return quoteStateToAccepted;
  }

  public void setQuoteStateToAccepted(Boolean quoteStateToAccepted) {
    this.quoteStateToAccepted = quoteStateToAccepted;
  }

  @Override
  public String toString() {
    return "OrderMyQuoteCommand{id='" + id + "', version='" + version + "', quoteStateToAccepted='" + quoteStateToAccepted + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderMyQuoteCommand that = (OrderMyQuoteCommand) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(quoteStateToAccepted, that.quoteStateToAccepted);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, version, quoteStateToAccepted);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private Long version;

    private Boolean quoteStateToAccepted = false;

    public OrderMyQuoteCommand build() {
      OrderMyQuoteCommand result = new OrderMyQuoteCommand();
      result.id = this.id;
      result.version = this.version;
      result.quoteStateToAccepted = this.quoteStateToAccepted;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder quoteStateToAccepted(Boolean quoteStateToAccepted) {
      this.quoteStateToAccepted = quoteStateToAccepted;
      return this;
    }
  }
}
