package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderPaymentStateChanged implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private PaymentState paymentState;

  private PaymentState oldPaymentState;

  private String type;

  public OrderPaymentStateChanged() {
  }

  public OrderPaymentStateChanged(PaymentState paymentState, PaymentState oldPaymentState,
      String type) {
    this.paymentState = paymentState;
    this.oldPaymentState = oldPaymentState;
    this.type = type;
  }

  public PaymentState getPaymentState() {
    return paymentState;
  }

  public void setPaymentState(PaymentState paymentState) {
    this.paymentState = paymentState;
  }

  public PaymentState getOldPaymentState() {
    return oldPaymentState;
  }

  public void setOldPaymentState(PaymentState oldPaymentState) {
    this.oldPaymentState = oldPaymentState;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderPaymentStateChanged{paymentState='" + paymentState + "', oldPaymentState='" + oldPaymentState + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderPaymentStateChanged that = (OrderPaymentStateChanged) o;
    return Objects.equals(paymentState, that.paymentState) &&
        Objects.equals(oldPaymentState, that.oldPaymentState) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentState, oldPaymentState, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private PaymentState paymentState;

    private PaymentState oldPaymentState;

    private String type;

    public OrderPaymentStateChanged build() {
      OrderPaymentStateChanged result = new OrderPaymentStateChanged();
      result.paymentState = this.paymentState;
      result.oldPaymentState = this.oldPaymentState;
      result.type = this.type;
      return result;
    }

    public Builder paymentState(PaymentState paymentState) {
      this.paymentState = paymentState;
      return this;
    }

    public Builder oldPaymentState(PaymentState oldPaymentState) {
      this.oldPaymentState = oldPaymentState;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
