package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderReturnShipmentStateChanged implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String returnItemId;

  private ReturnShipmentState returnShipmentState;

  private String type;

  public OrderReturnShipmentStateChanged() {
  }

  public OrderReturnShipmentStateChanged(String returnItemId,
      ReturnShipmentState returnShipmentState, String type) {
    this.returnItemId = returnItemId;
    this.returnShipmentState = returnShipmentState;
    this.type = type;
  }

  public String getReturnItemId() {
    return returnItemId;
  }

  public void setReturnItemId(String returnItemId) {
    this.returnItemId = returnItemId;
  }

  public ReturnShipmentState getReturnShipmentState() {
    return returnShipmentState;
  }

  public void setReturnShipmentState(ReturnShipmentState returnShipmentState) {
    this.returnShipmentState = returnShipmentState;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderReturnShipmentStateChanged{returnItemId='" + returnItemId + "', returnShipmentState='" + returnShipmentState + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderReturnShipmentStateChanged that = (OrderReturnShipmentStateChanged) o;
    return Objects.equals(returnItemId, that.returnItemId) &&
        Objects.equals(returnShipmentState, that.returnShipmentState) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(returnItemId, returnShipmentState, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String returnItemId;

    private ReturnShipmentState returnShipmentState;

    private String type;

    public OrderReturnShipmentStateChanged build() {
      OrderReturnShipmentStateChanged result = new OrderReturnShipmentStateChanged();
      result.returnItemId = this.returnItemId;
      result.returnShipmentState = this.returnShipmentState;
      result.type = this.type;
      return result;
    }

    public Builder returnItemId(String returnItemId) {
      this.returnItemId = returnItemId;
      return this;
    }

    public Builder returnShipmentState(ReturnShipmentState returnShipmentState) {
      this.returnShipmentState = returnShipmentState;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
