package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class OrderSearchConfiguration {
  private OrderSearchStatus status;

  private OffsetDateTime lastModifiedAt;

  private Initiator lastModifiedBy;

  public OrderSearchConfiguration() {
  }

  public OrderSearchConfiguration(OrderSearchStatus status, OffsetDateTime lastModifiedAt,
      Initiator lastModifiedBy) {
    this.status = status;
    this.lastModifiedAt = lastModifiedAt;
    this.lastModifiedBy = lastModifiedBy;
  }

  public OrderSearchStatus getStatus() {
    return status;
  }

  public void setStatus(OrderSearchStatus status) {
    this.status = status;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "OrderSearchConfiguration{status='" + status + "', lastModifiedAt='" + lastModifiedAt + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderSearchConfiguration that = (OrderSearchConfiguration) o;
    return Objects.equals(status, that.status) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, lastModifiedAt, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OrderSearchStatus status;

    private OffsetDateTime lastModifiedAt;

    private Initiator lastModifiedBy;

    public OrderSearchConfiguration build() {
      OrderSearchConfiguration result = new OrderSearchConfiguration();
      result.status = this.status;
      result.lastModifiedAt = this.lastModifiedAt;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder status(OrderSearchStatus status) {
      this.status = status;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
