package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderShipmentStateChanged implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private ShipmentState shipmentState;

  private ShipmentState oldShipmentState;

  private String type;

  public OrderShipmentStateChanged() {
  }

  public OrderShipmentStateChanged(ShipmentState shipmentState, ShipmentState oldShipmentState,
      String type) {
    this.shipmentState = shipmentState;
    this.oldShipmentState = oldShipmentState;
    this.type = type;
  }

  public ShipmentState getShipmentState() {
    return shipmentState;
  }

  public void setShipmentState(ShipmentState shipmentState) {
    this.shipmentState = shipmentState;
  }

  public ShipmentState getOldShipmentState() {
    return oldShipmentState;
  }

  public void setOldShipmentState(ShipmentState oldShipmentState) {
    this.oldShipmentState = oldShipmentState;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderShipmentStateChanged{shipmentState='" + shipmentState + "', oldShipmentState='" + oldShipmentState + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderShipmentStateChanged that = (OrderShipmentStateChanged) o;
    return Objects.equals(shipmentState, that.shipmentState) &&
        Objects.equals(oldShipmentState, that.oldShipmentState) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shipmentState, oldShipmentState, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ShipmentState shipmentState;

    private ShipmentState oldShipmentState;

    private String type;

    public OrderShipmentStateChanged build() {
      OrderShipmentStateChanged result = new OrderShipmentStateChanged();
      result.shipmentState = this.shipmentState;
      result.oldShipmentState = this.oldShipmentState;
      result.type = this.type;
      return result;
    }

    public Builder shipmentState(ShipmentState shipmentState) {
      this.shipmentState = shipmentState;
      return this;
    }

    public Builder oldShipmentState(ShipmentState oldShipmentState) {
      this.oldShipmentState = oldShipmentState;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
