package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderShippingAddressSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private Address address;

  private Address oldAddress;

  private String type;

  public OrderShippingAddressSet() {
  }

  public OrderShippingAddressSet(Address address, Address oldAddress, String type) {
    this.address = address;
    this.oldAddress = oldAddress;
    this.type = type;
  }

  public Address getAddress() {
    return address;
  }

  public void setAddress(Address address) {
    this.address = address;
  }

  public Address getOldAddress() {
    return oldAddress;
  }

  public void setOldAddress(Address oldAddress) {
    this.oldAddress = oldAddress;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderShippingAddressSet{address='" + address + "', oldAddress='" + oldAddress + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderShippingAddressSet that = (OrderShippingAddressSet) o;
    return Objects.equals(address, that.address) &&
        Objects.equals(oldAddress, that.oldAddress) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, oldAddress, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Address address;

    private Address oldAddress;

    private String type;

    public OrderShippingAddressSet build() {
      OrderShippingAddressSet result = new OrderShippingAddressSet();
      result.address = this.address;
      result.oldAddress = this.oldAddress;
      result.type = this.type;
      return result;
    }

    public Builder address(Address address) {
      this.address = address;
      return this;
    }

    public Builder oldAddress(Address oldAddress) {
      this.oldAddress = oldAddress;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
