package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderShippingInfoSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private ShippingInfo shippingInfo;

  private ShippingInfo oldShippingInfo;

  private String type;

  public OrderShippingInfoSet() {
  }

  public OrderShippingInfoSet(ShippingInfo shippingInfo, ShippingInfo oldShippingInfo,
      String type) {
    this.shippingInfo = shippingInfo;
    this.oldShippingInfo = oldShippingInfo;
    this.type = type;
  }

  public ShippingInfo getShippingInfo() {
    return shippingInfo;
  }

  public void setShippingInfo(ShippingInfo shippingInfo) {
    this.shippingInfo = shippingInfo;
  }

  public ShippingInfo getOldShippingInfo() {
    return oldShippingInfo;
  }

  public void setOldShippingInfo(ShippingInfo oldShippingInfo) {
    this.oldShippingInfo = oldShippingInfo;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderShippingInfoSet{shippingInfo='" + shippingInfo + "', oldShippingInfo='" + oldShippingInfo + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderShippingInfoSet that = (OrderShippingInfoSet) o;
    return Objects.equals(shippingInfo, that.shippingInfo) &&
        Objects.equals(oldShippingInfo, that.oldShippingInfo) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingInfo, oldShippingInfo, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ShippingInfo shippingInfo;

    private ShippingInfo oldShippingInfo;

    private String type;

    public OrderShippingInfoSet build() {
      OrderShippingInfoSet result = new OrderShippingInfoSet();
      result.shippingInfo = this.shippingInfo;
      result.oldShippingInfo = this.oldShippingInfo;
      result.type = this.type;
      return result;
    }

    public Builder shippingInfo(ShippingInfo shippingInfo) {
      this.shippingInfo = shippingInfo;
      return this;
    }

    public Builder oldShippingInfo(ShippingInfo oldShippingInfo) {
      this.oldShippingInfo = oldShippingInfo;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
