package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderShippingRateInputSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private ShippingRateInput shippingRateInput;

  private ShippingRateInput oldShippingRateInput;

  private String type;

  public OrderShippingRateInputSet() {
  }

  public OrderShippingRateInputSet(ShippingRateInput shippingRateInput,
      ShippingRateInput oldShippingRateInput, String type) {
    this.shippingRateInput = shippingRateInput;
    this.oldShippingRateInput = oldShippingRateInput;
    this.type = type;
  }

  public ShippingRateInput getShippingRateInput() {
    return shippingRateInput;
  }

  public void setShippingRateInput(ShippingRateInput shippingRateInput) {
    this.shippingRateInput = shippingRateInput;
  }

  public ShippingRateInput getOldShippingRateInput() {
    return oldShippingRateInput;
  }

  public void setOldShippingRateInput(ShippingRateInput oldShippingRateInput) {
    this.oldShippingRateInput = oldShippingRateInput;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderShippingRateInputSet{shippingRateInput='" + shippingRateInput + "', oldShippingRateInput='" + oldShippingRateInput + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderShippingRateInputSet that = (OrderShippingRateInputSet) o;
    return Objects.equals(shippingRateInput, that.shippingRateInput) &&
        Objects.equals(oldShippingRateInput, that.oldShippingRateInput) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingRateInput, oldShippingRateInput, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ShippingRateInput shippingRateInput;

    private ShippingRateInput oldShippingRateInput;

    private String type;

    public OrderShippingRateInputSet build() {
      OrderShippingRateInputSet result = new OrderShippingRateInputSet();
      result.shippingRateInput = this.shippingRateInput;
      result.oldShippingRateInput = this.oldShippingRateInput;
      result.type = this.type;
      return result;
    }

    public Builder shippingRateInput(ShippingRateInput shippingRateInput) {
      this.shippingRateInput = shippingRateInput;
      return this;
    }

    public Builder oldShippingRateInput(ShippingRateInput oldShippingRateInput) {
      this.oldShippingRateInput = oldShippingRateInput;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
