package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderShippingUpdated implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private Shipping current;

  private Shipping updated;

  private String type;

  public OrderShippingUpdated() {
  }

  public OrderShippingUpdated(Shipping current, Shipping updated, String type) {
    this.current = current;
    this.updated = updated;
    this.type = type;
  }

  public Shipping getCurrent() {
    return current;
  }

  public void setCurrent(Shipping current) {
    this.current = current;
  }

  public Shipping getUpdated() {
    return updated;
  }

  public void setUpdated(Shipping updated) {
    this.updated = updated;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderShippingUpdated{current='" + current + "', updated='" + updated + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderShippingUpdated that = (OrderShippingUpdated) o;
    return Objects.equals(current, that.current) &&
        Objects.equals(updated, that.updated) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(current, updated, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Shipping current;

    private Shipping updated;

    private String type;

    public OrderShippingUpdated build() {
      OrderShippingUpdated result = new OrderShippingUpdated();
      result.current = this.current;
      result.updated = this.updated;
      result.type = this.type;
      return result;
    }

    public Builder current(Shipping current) {
      this.current = current;
      return this;
    }

    public Builder updated(Shipping updated) {
      this.updated = updated;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
