package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class OrderUpdateAction {
  private AddOrderDelivery addDelivery;

  private AddOrderItemShippingAddress addItemShippingAddress;

  private AddOrderParcelToDelivery addParcelToDelivery;

  private AddOrderPayment addPayment;

  private AddOrderReturnInfo addReturnInfo;

  private ChangeOrderState changeOrderState;

  private ChangeOrderPaymentState changePaymentState;

  private ChangeOrderShipmentState changeShipmentState;

  private ImportOrderCustomLineItemState importCustomLineItemState;

  private ImportOrderLineItemState importLineItemState;

  private RemoveOrderDelivery removeDelivery;

  private RemoveOrderItemShippingAddress removeItemShippingAddress;

  private RemoveOrderParcelFromDelivery removeParcelFromDelivery;

  private RemoveOrderPayment removePayment;

  private SetOrderBillingAddress setBillingAddress;

  private SetOrderBillingAddressCustomField setBillingAddressCustomField;

  private SetOrderBillingAddressCustomType setBillingAddressCustomType;

  private SetOrderCustomField setCustomField;

  private SetOrderCustomLineItemCustomField setCustomLineItemCustomField;

  private SetOrderCustomLineItemCustomType setCustomLineItemCustomType;

  private SetOrderCustomLineItemShippingDetails setCustomLineItemShippingDetails;

  private SetOrderCustomType setCustomType;

  private SetOrderCustomerEmail setCustomerEmail;

  private SetOrderCustomerId setCustomerId;

  private SetOrderDeliveryAddress setDeliveryAddress;

  private SetOrderDeliveryAddressCustomField setDeliveryAddressCustomField;

  private SetOrderDeliveryAddressCustomType setDeliveryAddressCustomType;

  private SetOrderDeliveryCustomField setDeliveryCustomField;

  private SetOrderDeliveryCustomType setDeliveryCustomType;

  private SetOrderDeliveryItems setDeliveryItems;

  private SetOrderItemShippingAddressCustomField setItemShippingAddressCustomField;

  private SetOrderItemShippingAddressCustomType setItemShippingAddressCustomType;

  private SetOrderLineItemCustomField setLineItemCustomField;

  private SetOrderLineItemCustomType setLineItemCustomType;

  private SetOrderLineItemShippingDetails setLineItemShippingDetails;

  private SetOrderLocale setLocale;

  private SetOrderBusinessUnit setBusinessUnit;

  private SetOrderNumber setOrderNumber;

  private SetOrderParcelCustomField setParcelCustomField;

  private SetOrderParcelCustomType setParcelCustomType;

  private SetOrderParcelItems setParcelItems;

  private SetOrderParcelMeasurements setParcelMeasurements;

  private SetOrderParcelTrackingData setParcelTrackingData;

  private SetOrderPurchaseOrderNumber setPurchaseOrderNumber;

  private SetOrderReturnInfo setReturnInfo;

  private SetOrderReturnItemCustomField setReturnItemCustomField;

  private SetOrderReturnItemCustomType setReturnItemCustomType;

  private SetOrderReturnPaymentState setReturnPaymentState;

  private SetOrderReturnShipmentState setReturnShipmentState;

  private SetOrderShippingAddress setShippingAddress;

  private SetOrderShippingAddressCustomField setShippingAddressCustomField;

  private SetOrderShippingAddressCustomType setShippingAddressCustomType;

  private SetOrderShippingCustomField setShippingCustomField;

  private SetOrderShippingCustomType setShippingCustomType;

  private SetOrderStore setStore;

  private TransitionOrderCustomLineItemState transitionCustomLineItemState;

  private TransitionOrderLineItemState transitionLineItemState;

  private TransitionOrderState transitionState;

  private UpdateOrderItemShippingAddress updateItemShippingAddress;

  private UpdateOrderSyncInfo updateSyncInfo;

  public OrderUpdateAction() {
  }

  public OrderUpdateAction(AddOrderDelivery addDelivery,
      AddOrderItemShippingAddress addItemShippingAddress,
      AddOrderParcelToDelivery addParcelToDelivery, AddOrderPayment addPayment,
      AddOrderReturnInfo addReturnInfo, ChangeOrderState changeOrderState,
      ChangeOrderPaymentState changePaymentState, ChangeOrderShipmentState changeShipmentState,
      ImportOrderCustomLineItemState importCustomLineItemState,
      ImportOrderLineItemState importLineItemState, RemoveOrderDelivery removeDelivery,
      RemoveOrderItemShippingAddress removeItemShippingAddress,
      RemoveOrderParcelFromDelivery removeParcelFromDelivery, RemoveOrderPayment removePayment,
      SetOrderBillingAddress setBillingAddress,
      SetOrderBillingAddressCustomField setBillingAddressCustomField,
      SetOrderBillingAddressCustomType setBillingAddressCustomType,
      SetOrderCustomField setCustomField,
      SetOrderCustomLineItemCustomField setCustomLineItemCustomField,
      SetOrderCustomLineItemCustomType setCustomLineItemCustomType,
      SetOrderCustomLineItemShippingDetails setCustomLineItemShippingDetails,
      SetOrderCustomType setCustomType, SetOrderCustomerEmail setCustomerEmail,
      SetOrderCustomerId setCustomerId, SetOrderDeliveryAddress setDeliveryAddress,
      SetOrderDeliveryAddressCustomField setDeliveryAddressCustomField,
      SetOrderDeliveryAddressCustomType setDeliveryAddressCustomType,
      SetOrderDeliveryCustomField setDeliveryCustomField,
      SetOrderDeliveryCustomType setDeliveryCustomType, SetOrderDeliveryItems setDeliveryItems,
      SetOrderItemShippingAddressCustomField setItemShippingAddressCustomField,
      SetOrderItemShippingAddressCustomType setItemShippingAddressCustomType,
      SetOrderLineItemCustomField setLineItemCustomField,
      SetOrderLineItemCustomType setLineItemCustomType,
      SetOrderLineItemShippingDetails setLineItemShippingDetails, SetOrderLocale setLocale,
      SetOrderBusinessUnit setBusinessUnit, SetOrderNumber setOrderNumber,
      SetOrderParcelCustomField setParcelCustomField, SetOrderParcelCustomType setParcelCustomType,
      SetOrderParcelItems setParcelItems, SetOrderParcelMeasurements setParcelMeasurements,
      SetOrderParcelTrackingData setParcelTrackingData,
      SetOrderPurchaseOrderNumber setPurchaseOrderNumber, SetOrderReturnInfo setReturnInfo,
      SetOrderReturnItemCustomField setReturnItemCustomField,
      SetOrderReturnItemCustomType setReturnItemCustomType,
      SetOrderReturnPaymentState setReturnPaymentState,
      SetOrderReturnShipmentState setReturnShipmentState,
      SetOrderShippingAddress setShippingAddress,
      SetOrderShippingAddressCustomField setShippingAddressCustomField,
      SetOrderShippingAddressCustomType setShippingAddressCustomType,
      SetOrderShippingCustomField setShippingCustomField,
      SetOrderShippingCustomType setShippingCustomType, SetOrderStore setStore,
      TransitionOrderCustomLineItemState transitionCustomLineItemState,
      TransitionOrderLineItemState transitionLineItemState, TransitionOrderState transitionState,
      UpdateOrderItemShippingAddress updateItemShippingAddress,
      UpdateOrderSyncInfo updateSyncInfo) {
    this.addDelivery = addDelivery;
    this.addItemShippingAddress = addItemShippingAddress;
    this.addParcelToDelivery = addParcelToDelivery;
    this.addPayment = addPayment;
    this.addReturnInfo = addReturnInfo;
    this.changeOrderState = changeOrderState;
    this.changePaymentState = changePaymentState;
    this.changeShipmentState = changeShipmentState;
    this.importCustomLineItemState = importCustomLineItemState;
    this.importLineItemState = importLineItemState;
    this.removeDelivery = removeDelivery;
    this.removeItemShippingAddress = removeItemShippingAddress;
    this.removeParcelFromDelivery = removeParcelFromDelivery;
    this.removePayment = removePayment;
    this.setBillingAddress = setBillingAddress;
    this.setBillingAddressCustomField = setBillingAddressCustomField;
    this.setBillingAddressCustomType = setBillingAddressCustomType;
    this.setCustomField = setCustomField;
    this.setCustomLineItemCustomField = setCustomLineItemCustomField;
    this.setCustomLineItemCustomType = setCustomLineItemCustomType;
    this.setCustomLineItemShippingDetails = setCustomLineItemShippingDetails;
    this.setCustomType = setCustomType;
    this.setCustomerEmail = setCustomerEmail;
    this.setCustomerId = setCustomerId;
    this.setDeliveryAddress = setDeliveryAddress;
    this.setDeliveryAddressCustomField = setDeliveryAddressCustomField;
    this.setDeliveryAddressCustomType = setDeliveryAddressCustomType;
    this.setDeliveryCustomField = setDeliveryCustomField;
    this.setDeliveryCustomType = setDeliveryCustomType;
    this.setDeliveryItems = setDeliveryItems;
    this.setItemShippingAddressCustomField = setItemShippingAddressCustomField;
    this.setItemShippingAddressCustomType = setItemShippingAddressCustomType;
    this.setLineItemCustomField = setLineItemCustomField;
    this.setLineItemCustomType = setLineItemCustomType;
    this.setLineItemShippingDetails = setLineItemShippingDetails;
    this.setLocale = setLocale;
    this.setBusinessUnit = setBusinessUnit;
    this.setOrderNumber = setOrderNumber;
    this.setParcelCustomField = setParcelCustomField;
    this.setParcelCustomType = setParcelCustomType;
    this.setParcelItems = setParcelItems;
    this.setParcelMeasurements = setParcelMeasurements;
    this.setParcelTrackingData = setParcelTrackingData;
    this.setPurchaseOrderNumber = setPurchaseOrderNumber;
    this.setReturnInfo = setReturnInfo;
    this.setReturnItemCustomField = setReturnItemCustomField;
    this.setReturnItemCustomType = setReturnItemCustomType;
    this.setReturnPaymentState = setReturnPaymentState;
    this.setReturnShipmentState = setReturnShipmentState;
    this.setShippingAddress = setShippingAddress;
    this.setShippingAddressCustomField = setShippingAddressCustomField;
    this.setShippingAddressCustomType = setShippingAddressCustomType;
    this.setShippingCustomField = setShippingCustomField;
    this.setShippingCustomType = setShippingCustomType;
    this.setStore = setStore;
    this.transitionCustomLineItemState = transitionCustomLineItemState;
    this.transitionLineItemState = transitionLineItemState;
    this.transitionState = transitionState;
    this.updateItemShippingAddress = updateItemShippingAddress;
    this.updateSyncInfo = updateSyncInfo;
  }

  public AddOrderDelivery getAddDelivery() {
    return addDelivery;
  }

  public void setAddDelivery(AddOrderDelivery addDelivery) {
    this.addDelivery = addDelivery;
  }

  public AddOrderItemShippingAddress getAddItemShippingAddress() {
    return addItemShippingAddress;
  }

  public void setAddItemShippingAddress(AddOrderItemShippingAddress addItemShippingAddress) {
    this.addItemShippingAddress = addItemShippingAddress;
  }

  public AddOrderParcelToDelivery getAddParcelToDelivery() {
    return addParcelToDelivery;
  }

  public void setAddParcelToDelivery(AddOrderParcelToDelivery addParcelToDelivery) {
    this.addParcelToDelivery = addParcelToDelivery;
  }

  public AddOrderPayment getAddPayment() {
    return addPayment;
  }

  public void setAddPayment(AddOrderPayment addPayment) {
    this.addPayment = addPayment;
  }

  public AddOrderReturnInfo getAddReturnInfo() {
    return addReturnInfo;
  }

  public void setAddReturnInfo(AddOrderReturnInfo addReturnInfo) {
    this.addReturnInfo = addReturnInfo;
  }

  public ChangeOrderState getChangeOrderState() {
    return changeOrderState;
  }

  public void setChangeOrderState(ChangeOrderState changeOrderState) {
    this.changeOrderState = changeOrderState;
  }

  public ChangeOrderPaymentState getChangePaymentState() {
    return changePaymentState;
  }

  public void setChangePaymentState(ChangeOrderPaymentState changePaymentState) {
    this.changePaymentState = changePaymentState;
  }

  public ChangeOrderShipmentState getChangeShipmentState() {
    return changeShipmentState;
  }

  public void setChangeShipmentState(ChangeOrderShipmentState changeShipmentState) {
    this.changeShipmentState = changeShipmentState;
  }

  public ImportOrderCustomLineItemState getImportCustomLineItemState() {
    return importCustomLineItemState;
  }

  public void setImportCustomLineItemState(
      ImportOrderCustomLineItemState importCustomLineItemState) {
    this.importCustomLineItemState = importCustomLineItemState;
  }

  public ImportOrderLineItemState getImportLineItemState() {
    return importLineItemState;
  }

  public void setImportLineItemState(ImportOrderLineItemState importLineItemState) {
    this.importLineItemState = importLineItemState;
  }

  public RemoveOrderDelivery getRemoveDelivery() {
    return removeDelivery;
  }

  public void setRemoveDelivery(RemoveOrderDelivery removeDelivery) {
    this.removeDelivery = removeDelivery;
  }

  public RemoveOrderItemShippingAddress getRemoveItemShippingAddress() {
    return removeItemShippingAddress;
  }

  public void setRemoveItemShippingAddress(
      RemoveOrderItemShippingAddress removeItemShippingAddress) {
    this.removeItemShippingAddress = removeItemShippingAddress;
  }

  public RemoveOrderParcelFromDelivery getRemoveParcelFromDelivery() {
    return removeParcelFromDelivery;
  }

  public void setRemoveParcelFromDelivery(RemoveOrderParcelFromDelivery removeParcelFromDelivery) {
    this.removeParcelFromDelivery = removeParcelFromDelivery;
  }

  public RemoveOrderPayment getRemovePayment() {
    return removePayment;
  }

  public void setRemovePayment(RemoveOrderPayment removePayment) {
    this.removePayment = removePayment;
  }

  public SetOrderBillingAddress getSetBillingAddress() {
    return setBillingAddress;
  }

  public void setSetBillingAddress(SetOrderBillingAddress setBillingAddress) {
    this.setBillingAddress = setBillingAddress;
  }

  public SetOrderBillingAddressCustomField getSetBillingAddressCustomField() {
    return setBillingAddressCustomField;
  }

  public void setSetBillingAddressCustomField(
      SetOrderBillingAddressCustomField setBillingAddressCustomField) {
    this.setBillingAddressCustomField = setBillingAddressCustomField;
  }

  public SetOrderBillingAddressCustomType getSetBillingAddressCustomType() {
    return setBillingAddressCustomType;
  }

  public void setSetBillingAddressCustomType(
      SetOrderBillingAddressCustomType setBillingAddressCustomType) {
    this.setBillingAddressCustomType = setBillingAddressCustomType;
  }

  public SetOrderCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetOrderCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetOrderCustomLineItemCustomField getSetCustomLineItemCustomField() {
    return setCustomLineItemCustomField;
  }

  public void setSetCustomLineItemCustomField(
      SetOrderCustomLineItemCustomField setCustomLineItemCustomField) {
    this.setCustomLineItemCustomField = setCustomLineItemCustomField;
  }

  public SetOrderCustomLineItemCustomType getSetCustomLineItemCustomType() {
    return setCustomLineItemCustomType;
  }

  public void setSetCustomLineItemCustomType(
      SetOrderCustomLineItemCustomType setCustomLineItemCustomType) {
    this.setCustomLineItemCustomType = setCustomLineItemCustomType;
  }

  public SetOrderCustomLineItemShippingDetails getSetCustomLineItemShippingDetails() {
    return setCustomLineItemShippingDetails;
  }

  public void setSetCustomLineItemShippingDetails(
      SetOrderCustomLineItemShippingDetails setCustomLineItemShippingDetails) {
    this.setCustomLineItemShippingDetails = setCustomLineItemShippingDetails;
  }

  public SetOrderCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetOrderCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetOrderCustomerEmail getSetCustomerEmail() {
    return setCustomerEmail;
  }

  public void setSetCustomerEmail(SetOrderCustomerEmail setCustomerEmail) {
    this.setCustomerEmail = setCustomerEmail;
  }

  public SetOrderCustomerId getSetCustomerId() {
    return setCustomerId;
  }

  public void setSetCustomerId(SetOrderCustomerId setCustomerId) {
    this.setCustomerId = setCustomerId;
  }

  public SetOrderDeliveryAddress getSetDeliveryAddress() {
    return setDeliveryAddress;
  }

  public void setSetDeliveryAddress(SetOrderDeliveryAddress setDeliveryAddress) {
    this.setDeliveryAddress = setDeliveryAddress;
  }

  public SetOrderDeliveryAddressCustomField getSetDeliveryAddressCustomField() {
    return setDeliveryAddressCustomField;
  }

  public void setSetDeliveryAddressCustomField(
      SetOrderDeliveryAddressCustomField setDeliveryAddressCustomField) {
    this.setDeliveryAddressCustomField = setDeliveryAddressCustomField;
  }

  public SetOrderDeliveryAddressCustomType getSetDeliveryAddressCustomType() {
    return setDeliveryAddressCustomType;
  }

  public void setSetDeliveryAddressCustomType(
      SetOrderDeliveryAddressCustomType setDeliveryAddressCustomType) {
    this.setDeliveryAddressCustomType = setDeliveryAddressCustomType;
  }

  public SetOrderDeliveryCustomField getSetDeliveryCustomField() {
    return setDeliveryCustomField;
  }

  public void setSetDeliveryCustomField(SetOrderDeliveryCustomField setDeliveryCustomField) {
    this.setDeliveryCustomField = setDeliveryCustomField;
  }

  public SetOrderDeliveryCustomType getSetDeliveryCustomType() {
    return setDeliveryCustomType;
  }

  public void setSetDeliveryCustomType(SetOrderDeliveryCustomType setDeliveryCustomType) {
    this.setDeliveryCustomType = setDeliveryCustomType;
  }

  public SetOrderDeliveryItems getSetDeliveryItems() {
    return setDeliveryItems;
  }

  public void setSetDeliveryItems(SetOrderDeliveryItems setDeliveryItems) {
    this.setDeliveryItems = setDeliveryItems;
  }

  public SetOrderItemShippingAddressCustomField getSetItemShippingAddressCustomField() {
    return setItemShippingAddressCustomField;
  }

  public void setSetItemShippingAddressCustomField(
      SetOrderItemShippingAddressCustomField setItemShippingAddressCustomField) {
    this.setItemShippingAddressCustomField = setItemShippingAddressCustomField;
  }

  public SetOrderItemShippingAddressCustomType getSetItemShippingAddressCustomType() {
    return setItemShippingAddressCustomType;
  }

  public void setSetItemShippingAddressCustomType(
      SetOrderItemShippingAddressCustomType setItemShippingAddressCustomType) {
    this.setItemShippingAddressCustomType = setItemShippingAddressCustomType;
  }

  public SetOrderLineItemCustomField getSetLineItemCustomField() {
    return setLineItemCustomField;
  }

  public void setSetLineItemCustomField(SetOrderLineItemCustomField setLineItemCustomField) {
    this.setLineItemCustomField = setLineItemCustomField;
  }

  public SetOrderLineItemCustomType getSetLineItemCustomType() {
    return setLineItemCustomType;
  }

  public void setSetLineItemCustomType(SetOrderLineItemCustomType setLineItemCustomType) {
    this.setLineItemCustomType = setLineItemCustomType;
  }

  public SetOrderLineItemShippingDetails getSetLineItemShippingDetails() {
    return setLineItemShippingDetails;
  }

  public void setSetLineItemShippingDetails(
      SetOrderLineItemShippingDetails setLineItemShippingDetails) {
    this.setLineItemShippingDetails = setLineItemShippingDetails;
  }

  public SetOrderLocale getSetLocale() {
    return setLocale;
  }

  public void setSetLocale(SetOrderLocale setLocale) {
    this.setLocale = setLocale;
  }

  public SetOrderBusinessUnit getSetBusinessUnit() {
    return setBusinessUnit;
  }

  public void setSetBusinessUnit(SetOrderBusinessUnit setBusinessUnit) {
    this.setBusinessUnit = setBusinessUnit;
  }

  public SetOrderNumber getSetOrderNumber() {
    return setOrderNumber;
  }

  public void setSetOrderNumber(SetOrderNumber setOrderNumber) {
    this.setOrderNumber = setOrderNumber;
  }

  public SetOrderParcelCustomField getSetParcelCustomField() {
    return setParcelCustomField;
  }

  public void setSetParcelCustomField(SetOrderParcelCustomField setParcelCustomField) {
    this.setParcelCustomField = setParcelCustomField;
  }

  public SetOrderParcelCustomType getSetParcelCustomType() {
    return setParcelCustomType;
  }

  public void setSetParcelCustomType(SetOrderParcelCustomType setParcelCustomType) {
    this.setParcelCustomType = setParcelCustomType;
  }

  public SetOrderParcelItems getSetParcelItems() {
    return setParcelItems;
  }

  public void setSetParcelItems(SetOrderParcelItems setParcelItems) {
    this.setParcelItems = setParcelItems;
  }

  public SetOrderParcelMeasurements getSetParcelMeasurements() {
    return setParcelMeasurements;
  }

  public void setSetParcelMeasurements(SetOrderParcelMeasurements setParcelMeasurements) {
    this.setParcelMeasurements = setParcelMeasurements;
  }

  public SetOrderParcelTrackingData getSetParcelTrackingData() {
    return setParcelTrackingData;
  }

  public void setSetParcelTrackingData(SetOrderParcelTrackingData setParcelTrackingData) {
    this.setParcelTrackingData = setParcelTrackingData;
  }

  public SetOrderPurchaseOrderNumber getSetPurchaseOrderNumber() {
    return setPurchaseOrderNumber;
  }

  public void setSetPurchaseOrderNumber(SetOrderPurchaseOrderNumber setPurchaseOrderNumber) {
    this.setPurchaseOrderNumber = setPurchaseOrderNumber;
  }

  public SetOrderReturnInfo getSetReturnInfo() {
    return setReturnInfo;
  }

  public void setSetReturnInfo(SetOrderReturnInfo setReturnInfo) {
    this.setReturnInfo = setReturnInfo;
  }

  public SetOrderReturnItemCustomField getSetReturnItemCustomField() {
    return setReturnItemCustomField;
  }

  public void setSetReturnItemCustomField(SetOrderReturnItemCustomField setReturnItemCustomField) {
    this.setReturnItemCustomField = setReturnItemCustomField;
  }

  public SetOrderReturnItemCustomType getSetReturnItemCustomType() {
    return setReturnItemCustomType;
  }

  public void setSetReturnItemCustomType(SetOrderReturnItemCustomType setReturnItemCustomType) {
    this.setReturnItemCustomType = setReturnItemCustomType;
  }

  public SetOrderReturnPaymentState getSetReturnPaymentState() {
    return setReturnPaymentState;
  }

  public void setSetReturnPaymentState(SetOrderReturnPaymentState setReturnPaymentState) {
    this.setReturnPaymentState = setReturnPaymentState;
  }

  public SetOrderReturnShipmentState getSetReturnShipmentState() {
    return setReturnShipmentState;
  }

  public void setSetReturnShipmentState(SetOrderReturnShipmentState setReturnShipmentState) {
    this.setReturnShipmentState = setReturnShipmentState;
  }

  public SetOrderShippingAddress getSetShippingAddress() {
    return setShippingAddress;
  }

  public void setSetShippingAddress(SetOrderShippingAddress setShippingAddress) {
    this.setShippingAddress = setShippingAddress;
  }

  public SetOrderShippingAddressCustomField getSetShippingAddressCustomField() {
    return setShippingAddressCustomField;
  }

  public void setSetShippingAddressCustomField(
      SetOrderShippingAddressCustomField setShippingAddressCustomField) {
    this.setShippingAddressCustomField = setShippingAddressCustomField;
  }

  public SetOrderShippingAddressCustomType getSetShippingAddressCustomType() {
    return setShippingAddressCustomType;
  }

  public void setSetShippingAddressCustomType(
      SetOrderShippingAddressCustomType setShippingAddressCustomType) {
    this.setShippingAddressCustomType = setShippingAddressCustomType;
  }

  public SetOrderShippingCustomField getSetShippingCustomField() {
    return setShippingCustomField;
  }

  public void setSetShippingCustomField(SetOrderShippingCustomField setShippingCustomField) {
    this.setShippingCustomField = setShippingCustomField;
  }

  public SetOrderShippingCustomType getSetShippingCustomType() {
    return setShippingCustomType;
  }

  public void setSetShippingCustomType(SetOrderShippingCustomType setShippingCustomType) {
    this.setShippingCustomType = setShippingCustomType;
  }

  public SetOrderStore getSetStore() {
    return setStore;
  }

  public void setSetStore(SetOrderStore setStore) {
    this.setStore = setStore;
  }

  public TransitionOrderCustomLineItemState getTransitionCustomLineItemState() {
    return transitionCustomLineItemState;
  }

  public void setTransitionCustomLineItemState(
      TransitionOrderCustomLineItemState transitionCustomLineItemState) {
    this.transitionCustomLineItemState = transitionCustomLineItemState;
  }

  public TransitionOrderLineItemState getTransitionLineItemState() {
    return transitionLineItemState;
  }

  public void setTransitionLineItemState(TransitionOrderLineItemState transitionLineItemState) {
    this.transitionLineItemState = transitionLineItemState;
  }

  public TransitionOrderState getTransitionState() {
    return transitionState;
  }

  public void setTransitionState(TransitionOrderState transitionState) {
    this.transitionState = transitionState;
  }

  public UpdateOrderItemShippingAddress getUpdateItemShippingAddress() {
    return updateItemShippingAddress;
  }

  public void setUpdateItemShippingAddress(
      UpdateOrderItemShippingAddress updateItemShippingAddress) {
    this.updateItemShippingAddress = updateItemShippingAddress;
  }

  public UpdateOrderSyncInfo getUpdateSyncInfo() {
    return updateSyncInfo;
  }

  public void setUpdateSyncInfo(UpdateOrderSyncInfo updateSyncInfo) {
    this.updateSyncInfo = updateSyncInfo;
  }

  @Override
  public String toString() {
    return "OrderUpdateAction{addDelivery='" + addDelivery + "', addItemShippingAddress='" + addItemShippingAddress + "', addParcelToDelivery='" + addParcelToDelivery + "', addPayment='" + addPayment + "', addReturnInfo='" + addReturnInfo + "', changeOrderState='" + changeOrderState + "', changePaymentState='" + changePaymentState + "', changeShipmentState='" + changeShipmentState + "', importCustomLineItemState='" + importCustomLineItemState + "', importLineItemState='" + importLineItemState + "', removeDelivery='" + removeDelivery + "', removeItemShippingAddress='" + removeItemShippingAddress + "', removeParcelFromDelivery='" + removeParcelFromDelivery + "', removePayment='" + removePayment + "', setBillingAddress='" + setBillingAddress + "', setBillingAddressCustomField='" + setBillingAddressCustomField + "', setBillingAddressCustomType='" + setBillingAddressCustomType + "', setCustomField='" + setCustomField + "', setCustomLineItemCustomField='" + setCustomLineItemCustomField + "', setCustomLineItemCustomType='" + setCustomLineItemCustomType + "', setCustomLineItemShippingDetails='" + setCustomLineItemShippingDetails + "', setCustomType='" + setCustomType + "', setCustomerEmail='" + setCustomerEmail + "', setCustomerId='" + setCustomerId + "', setDeliveryAddress='" + setDeliveryAddress + "', setDeliveryAddressCustomField='" + setDeliveryAddressCustomField + "', setDeliveryAddressCustomType='" + setDeliveryAddressCustomType + "', setDeliveryCustomField='" + setDeliveryCustomField + "', setDeliveryCustomType='" + setDeliveryCustomType + "', setDeliveryItems='" + setDeliveryItems + "', setItemShippingAddressCustomField='" + setItemShippingAddressCustomField + "', setItemShippingAddressCustomType='" + setItemShippingAddressCustomType + "', setLineItemCustomField='" + setLineItemCustomField + "', setLineItemCustomType='" + setLineItemCustomType + "', setLineItemShippingDetails='" + setLineItemShippingDetails + "', setLocale='" + setLocale + "', setBusinessUnit='" + setBusinessUnit + "', setOrderNumber='" + setOrderNumber + "', setParcelCustomField='" + setParcelCustomField + "', setParcelCustomType='" + setParcelCustomType + "', setParcelItems='" + setParcelItems + "', setParcelMeasurements='" + setParcelMeasurements + "', setParcelTrackingData='" + setParcelTrackingData + "', setPurchaseOrderNumber='" + setPurchaseOrderNumber + "', setReturnInfo='" + setReturnInfo + "', setReturnItemCustomField='" + setReturnItemCustomField + "', setReturnItemCustomType='" + setReturnItemCustomType + "', setReturnPaymentState='" + setReturnPaymentState + "', setReturnShipmentState='" + setReturnShipmentState + "', setShippingAddress='" + setShippingAddress + "', setShippingAddressCustomField='" + setShippingAddressCustomField + "', setShippingAddressCustomType='" + setShippingAddressCustomType + "', setShippingCustomField='" + setShippingCustomField + "', setShippingCustomType='" + setShippingCustomType + "', setStore='" + setStore + "', transitionCustomLineItemState='" + transitionCustomLineItemState + "', transitionLineItemState='" + transitionLineItemState + "', transitionState='" + transitionState + "', updateItemShippingAddress='" + updateItemShippingAddress + "', updateSyncInfo='" + updateSyncInfo + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderUpdateAction that = (OrderUpdateAction) o;
    return Objects.equals(addDelivery, that.addDelivery) &&
        Objects.equals(addItemShippingAddress, that.addItemShippingAddress) &&
        Objects.equals(addParcelToDelivery, that.addParcelToDelivery) &&
        Objects.equals(addPayment, that.addPayment) &&
        Objects.equals(addReturnInfo, that.addReturnInfo) &&
        Objects.equals(changeOrderState, that.changeOrderState) &&
        Objects.equals(changePaymentState, that.changePaymentState) &&
        Objects.equals(changeShipmentState, that.changeShipmentState) &&
        Objects.equals(importCustomLineItemState, that.importCustomLineItemState) &&
        Objects.equals(importLineItemState, that.importLineItemState) &&
        Objects.equals(removeDelivery, that.removeDelivery) &&
        Objects.equals(removeItemShippingAddress, that.removeItemShippingAddress) &&
        Objects.equals(removeParcelFromDelivery, that.removeParcelFromDelivery) &&
        Objects.equals(removePayment, that.removePayment) &&
        Objects.equals(setBillingAddress, that.setBillingAddress) &&
        Objects.equals(setBillingAddressCustomField, that.setBillingAddressCustomField) &&
        Objects.equals(setBillingAddressCustomType, that.setBillingAddressCustomType) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomLineItemCustomField, that.setCustomLineItemCustomField) &&
        Objects.equals(setCustomLineItemCustomType, that.setCustomLineItemCustomType) &&
        Objects.equals(setCustomLineItemShippingDetails, that.setCustomLineItemShippingDetails) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setCustomerEmail, that.setCustomerEmail) &&
        Objects.equals(setCustomerId, that.setCustomerId) &&
        Objects.equals(setDeliveryAddress, that.setDeliveryAddress) &&
        Objects.equals(setDeliveryAddressCustomField, that.setDeliveryAddressCustomField) &&
        Objects.equals(setDeliveryAddressCustomType, that.setDeliveryAddressCustomType) &&
        Objects.equals(setDeliveryCustomField, that.setDeliveryCustomField) &&
        Objects.equals(setDeliveryCustomType, that.setDeliveryCustomType) &&
        Objects.equals(setDeliveryItems, that.setDeliveryItems) &&
        Objects.equals(setItemShippingAddressCustomField, that.setItemShippingAddressCustomField) &&
        Objects.equals(setItemShippingAddressCustomType, that.setItemShippingAddressCustomType) &&
        Objects.equals(setLineItemCustomField, that.setLineItemCustomField) &&
        Objects.equals(setLineItemCustomType, that.setLineItemCustomType) &&
        Objects.equals(setLineItemShippingDetails, that.setLineItemShippingDetails) &&
        Objects.equals(setLocale, that.setLocale) &&
        Objects.equals(setBusinessUnit, that.setBusinessUnit) &&
        Objects.equals(setOrderNumber, that.setOrderNumber) &&
        Objects.equals(setParcelCustomField, that.setParcelCustomField) &&
        Objects.equals(setParcelCustomType, that.setParcelCustomType) &&
        Objects.equals(setParcelItems, that.setParcelItems) &&
        Objects.equals(setParcelMeasurements, that.setParcelMeasurements) &&
        Objects.equals(setParcelTrackingData, that.setParcelTrackingData) &&
        Objects.equals(setPurchaseOrderNumber, that.setPurchaseOrderNumber) &&
        Objects.equals(setReturnInfo, that.setReturnInfo) &&
        Objects.equals(setReturnItemCustomField, that.setReturnItemCustomField) &&
        Objects.equals(setReturnItemCustomType, that.setReturnItemCustomType) &&
        Objects.equals(setReturnPaymentState, that.setReturnPaymentState) &&
        Objects.equals(setReturnShipmentState, that.setReturnShipmentState) &&
        Objects.equals(setShippingAddress, that.setShippingAddress) &&
        Objects.equals(setShippingAddressCustomField, that.setShippingAddressCustomField) &&
        Objects.equals(setShippingAddressCustomType, that.setShippingAddressCustomType) &&
        Objects.equals(setShippingCustomField, that.setShippingCustomField) &&
        Objects.equals(setShippingCustomType, that.setShippingCustomType) &&
        Objects.equals(setStore, that.setStore) &&
        Objects.equals(transitionCustomLineItemState, that.transitionCustomLineItemState) &&
        Objects.equals(transitionLineItemState, that.transitionLineItemState) &&
        Objects.equals(transitionState, that.transitionState) &&
        Objects.equals(updateItemShippingAddress, that.updateItemShippingAddress) &&
        Objects.equals(updateSyncInfo, that.updateSyncInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addDelivery, addItemShippingAddress, addParcelToDelivery, addPayment, addReturnInfo, changeOrderState, changePaymentState, changeShipmentState, importCustomLineItemState, importLineItemState, removeDelivery, removeItemShippingAddress, removeParcelFromDelivery, removePayment, setBillingAddress, setBillingAddressCustomField, setBillingAddressCustomType, setCustomField, setCustomLineItemCustomField, setCustomLineItemCustomType, setCustomLineItemShippingDetails, setCustomType, setCustomerEmail, setCustomerId, setDeliveryAddress, setDeliveryAddressCustomField, setDeliveryAddressCustomType, setDeliveryCustomField, setDeliveryCustomType, setDeliveryItems, setItemShippingAddressCustomField, setItemShippingAddressCustomType, setLineItemCustomField, setLineItemCustomType, setLineItemShippingDetails, setLocale, setBusinessUnit, setOrderNumber, setParcelCustomField, setParcelCustomType, setParcelItems, setParcelMeasurements, setParcelTrackingData, setPurchaseOrderNumber, setReturnInfo, setReturnItemCustomField, setReturnItemCustomType, setReturnPaymentState, setReturnShipmentState, setShippingAddress, setShippingAddressCustomField, setShippingAddressCustomType, setShippingCustomField, setShippingCustomType, setStore, transitionCustomLineItemState, transitionLineItemState, transitionState, updateItemShippingAddress, updateSyncInfo);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddOrderDelivery addDelivery;

    private AddOrderItemShippingAddress addItemShippingAddress;

    private AddOrderParcelToDelivery addParcelToDelivery;

    private AddOrderPayment addPayment;

    private AddOrderReturnInfo addReturnInfo;

    private ChangeOrderState changeOrderState;

    private ChangeOrderPaymentState changePaymentState;

    private ChangeOrderShipmentState changeShipmentState;

    private ImportOrderCustomLineItemState importCustomLineItemState;

    private ImportOrderLineItemState importLineItemState;

    private RemoveOrderDelivery removeDelivery;

    private RemoveOrderItemShippingAddress removeItemShippingAddress;

    private RemoveOrderParcelFromDelivery removeParcelFromDelivery;

    private RemoveOrderPayment removePayment;

    private SetOrderBillingAddress setBillingAddress;

    private SetOrderBillingAddressCustomField setBillingAddressCustomField;

    private SetOrderBillingAddressCustomType setBillingAddressCustomType;

    private SetOrderCustomField setCustomField;

    private SetOrderCustomLineItemCustomField setCustomLineItemCustomField;

    private SetOrderCustomLineItemCustomType setCustomLineItemCustomType;

    private SetOrderCustomLineItemShippingDetails setCustomLineItemShippingDetails;

    private SetOrderCustomType setCustomType;

    private SetOrderCustomerEmail setCustomerEmail;

    private SetOrderCustomerId setCustomerId;

    private SetOrderDeliveryAddress setDeliveryAddress;

    private SetOrderDeliveryAddressCustomField setDeliveryAddressCustomField;

    private SetOrderDeliveryAddressCustomType setDeliveryAddressCustomType;

    private SetOrderDeliveryCustomField setDeliveryCustomField;

    private SetOrderDeliveryCustomType setDeliveryCustomType;

    private SetOrderDeliveryItems setDeliveryItems;

    private SetOrderItemShippingAddressCustomField setItemShippingAddressCustomField;

    private SetOrderItemShippingAddressCustomType setItemShippingAddressCustomType;

    private SetOrderLineItemCustomField setLineItemCustomField;

    private SetOrderLineItemCustomType setLineItemCustomType;

    private SetOrderLineItemShippingDetails setLineItemShippingDetails;

    private SetOrderLocale setLocale;

    private SetOrderBusinessUnit setBusinessUnit;

    private SetOrderNumber setOrderNumber;

    private SetOrderParcelCustomField setParcelCustomField;

    private SetOrderParcelCustomType setParcelCustomType;

    private SetOrderParcelItems setParcelItems;

    private SetOrderParcelMeasurements setParcelMeasurements;

    private SetOrderParcelTrackingData setParcelTrackingData;

    private SetOrderPurchaseOrderNumber setPurchaseOrderNumber;

    private SetOrderReturnInfo setReturnInfo;

    private SetOrderReturnItemCustomField setReturnItemCustomField;

    private SetOrderReturnItemCustomType setReturnItemCustomType;

    private SetOrderReturnPaymentState setReturnPaymentState;

    private SetOrderReturnShipmentState setReturnShipmentState;

    private SetOrderShippingAddress setShippingAddress;

    private SetOrderShippingAddressCustomField setShippingAddressCustomField;

    private SetOrderShippingAddressCustomType setShippingAddressCustomType;

    private SetOrderShippingCustomField setShippingCustomField;

    private SetOrderShippingCustomType setShippingCustomType;

    private SetOrderStore setStore;

    private TransitionOrderCustomLineItemState transitionCustomLineItemState;

    private TransitionOrderLineItemState transitionLineItemState;

    private TransitionOrderState transitionState;

    private UpdateOrderItemShippingAddress updateItemShippingAddress;

    private UpdateOrderSyncInfo updateSyncInfo;

    public OrderUpdateAction build() {
      OrderUpdateAction result = new OrderUpdateAction();
      result.addDelivery = this.addDelivery;
      result.addItemShippingAddress = this.addItemShippingAddress;
      result.addParcelToDelivery = this.addParcelToDelivery;
      result.addPayment = this.addPayment;
      result.addReturnInfo = this.addReturnInfo;
      result.changeOrderState = this.changeOrderState;
      result.changePaymentState = this.changePaymentState;
      result.changeShipmentState = this.changeShipmentState;
      result.importCustomLineItemState = this.importCustomLineItemState;
      result.importLineItemState = this.importLineItemState;
      result.removeDelivery = this.removeDelivery;
      result.removeItemShippingAddress = this.removeItemShippingAddress;
      result.removeParcelFromDelivery = this.removeParcelFromDelivery;
      result.removePayment = this.removePayment;
      result.setBillingAddress = this.setBillingAddress;
      result.setBillingAddressCustomField = this.setBillingAddressCustomField;
      result.setBillingAddressCustomType = this.setBillingAddressCustomType;
      result.setCustomField = this.setCustomField;
      result.setCustomLineItemCustomField = this.setCustomLineItemCustomField;
      result.setCustomLineItemCustomType = this.setCustomLineItemCustomType;
      result.setCustomLineItemShippingDetails = this.setCustomLineItemShippingDetails;
      result.setCustomType = this.setCustomType;
      result.setCustomerEmail = this.setCustomerEmail;
      result.setCustomerId = this.setCustomerId;
      result.setDeliveryAddress = this.setDeliveryAddress;
      result.setDeliveryAddressCustomField = this.setDeliveryAddressCustomField;
      result.setDeliveryAddressCustomType = this.setDeliveryAddressCustomType;
      result.setDeliveryCustomField = this.setDeliveryCustomField;
      result.setDeliveryCustomType = this.setDeliveryCustomType;
      result.setDeliveryItems = this.setDeliveryItems;
      result.setItemShippingAddressCustomField = this.setItemShippingAddressCustomField;
      result.setItemShippingAddressCustomType = this.setItemShippingAddressCustomType;
      result.setLineItemCustomField = this.setLineItemCustomField;
      result.setLineItemCustomType = this.setLineItemCustomType;
      result.setLineItemShippingDetails = this.setLineItemShippingDetails;
      result.setLocale = this.setLocale;
      result.setBusinessUnit = this.setBusinessUnit;
      result.setOrderNumber = this.setOrderNumber;
      result.setParcelCustomField = this.setParcelCustomField;
      result.setParcelCustomType = this.setParcelCustomType;
      result.setParcelItems = this.setParcelItems;
      result.setParcelMeasurements = this.setParcelMeasurements;
      result.setParcelTrackingData = this.setParcelTrackingData;
      result.setPurchaseOrderNumber = this.setPurchaseOrderNumber;
      result.setReturnInfo = this.setReturnInfo;
      result.setReturnItemCustomField = this.setReturnItemCustomField;
      result.setReturnItemCustomType = this.setReturnItemCustomType;
      result.setReturnPaymentState = this.setReturnPaymentState;
      result.setReturnShipmentState = this.setReturnShipmentState;
      result.setShippingAddress = this.setShippingAddress;
      result.setShippingAddressCustomField = this.setShippingAddressCustomField;
      result.setShippingAddressCustomType = this.setShippingAddressCustomType;
      result.setShippingCustomField = this.setShippingCustomField;
      result.setShippingCustomType = this.setShippingCustomType;
      result.setStore = this.setStore;
      result.transitionCustomLineItemState = this.transitionCustomLineItemState;
      result.transitionLineItemState = this.transitionLineItemState;
      result.transitionState = this.transitionState;
      result.updateItemShippingAddress = this.updateItemShippingAddress;
      result.updateSyncInfo = this.updateSyncInfo;
      return result;
    }

    public Builder addDelivery(AddOrderDelivery addDelivery) {
      this.addDelivery = addDelivery;
      return this;
    }

    public Builder addItemShippingAddress(AddOrderItemShippingAddress addItemShippingAddress) {
      this.addItemShippingAddress = addItemShippingAddress;
      return this;
    }

    public Builder addParcelToDelivery(AddOrderParcelToDelivery addParcelToDelivery) {
      this.addParcelToDelivery = addParcelToDelivery;
      return this;
    }

    public Builder addPayment(AddOrderPayment addPayment) {
      this.addPayment = addPayment;
      return this;
    }

    public Builder addReturnInfo(AddOrderReturnInfo addReturnInfo) {
      this.addReturnInfo = addReturnInfo;
      return this;
    }

    public Builder changeOrderState(ChangeOrderState changeOrderState) {
      this.changeOrderState = changeOrderState;
      return this;
    }

    public Builder changePaymentState(ChangeOrderPaymentState changePaymentState) {
      this.changePaymentState = changePaymentState;
      return this;
    }

    public Builder changeShipmentState(ChangeOrderShipmentState changeShipmentState) {
      this.changeShipmentState = changeShipmentState;
      return this;
    }

    public Builder importCustomLineItemState(
        ImportOrderCustomLineItemState importCustomLineItemState) {
      this.importCustomLineItemState = importCustomLineItemState;
      return this;
    }

    public Builder importLineItemState(ImportOrderLineItemState importLineItemState) {
      this.importLineItemState = importLineItemState;
      return this;
    }

    public Builder removeDelivery(RemoveOrderDelivery removeDelivery) {
      this.removeDelivery = removeDelivery;
      return this;
    }

    public Builder removeItemShippingAddress(
        RemoveOrderItemShippingAddress removeItemShippingAddress) {
      this.removeItemShippingAddress = removeItemShippingAddress;
      return this;
    }

    public Builder removeParcelFromDelivery(
        RemoveOrderParcelFromDelivery removeParcelFromDelivery) {
      this.removeParcelFromDelivery = removeParcelFromDelivery;
      return this;
    }

    public Builder removePayment(RemoveOrderPayment removePayment) {
      this.removePayment = removePayment;
      return this;
    }

    public Builder setBillingAddress(SetOrderBillingAddress setBillingAddress) {
      this.setBillingAddress = setBillingAddress;
      return this;
    }

    public Builder setBillingAddressCustomField(
        SetOrderBillingAddressCustomField setBillingAddressCustomField) {
      this.setBillingAddressCustomField = setBillingAddressCustomField;
      return this;
    }

    public Builder setBillingAddressCustomType(
        SetOrderBillingAddressCustomType setBillingAddressCustomType) {
      this.setBillingAddressCustomType = setBillingAddressCustomType;
      return this;
    }

    public Builder setCustomField(SetOrderCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomLineItemCustomField(
        SetOrderCustomLineItemCustomField setCustomLineItemCustomField) {
      this.setCustomLineItemCustomField = setCustomLineItemCustomField;
      return this;
    }

    public Builder setCustomLineItemCustomType(
        SetOrderCustomLineItemCustomType setCustomLineItemCustomType) {
      this.setCustomLineItemCustomType = setCustomLineItemCustomType;
      return this;
    }

    public Builder setCustomLineItemShippingDetails(
        SetOrderCustomLineItemShippingDetails setCustomLineItemShippingDetails) {
      this.setCustomLineItemShippingDetails = setCustomLineItemShippingDetails;
      return this;
    }

    public Builder setCustomType(SetOrderCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setCustomerEmail(SetOrderCustomerEmail setCustomerEmail) {
      this.setCustomerEmail = setCustomerEmail;
      return this;
    }

    public Builder setCustomerId(SetOrderCustomerId setCustomerId) {
      this.setCustomerId = setCustomerId;
      return this;
    }

    public Builder setDeliveryAddress(SetOrderDeliveryAddress setDeliveryAddress) {
      this.setDeliveryAddress = setDeliveryAddress;
      return this;
    }

    public Builder setDeliveryAddressCustomField(
        SetOrderDeliveryAddressCustomField setDeliveryAddressCustomField) {
      this.setDeliveryAddressCustomField = setDeliveryAddressCustomField;
      return this;
    }

    public Builder setDeliveryAddressCustomType(
        SetOrderDeliveryAddressCustomType setDeliveryAddressCustomType) {
      this.setDeliveryAddressCustomType = setDeliveryAddressCustomType;
      return this;
    }

    public Builder setDeliveryCustomField(SetOrderDeliveryCustomField setDeliveryCustomField) {
      this.setDeliveryCustomField = setDeliveryCustomField;
      return this;
    }

    public Builder setDeliveryCustomType(SetOrderDeliveryCustomType setDeliveryCustomType) {
      this.setDeliveryCustomType = setDeliveryCustomType;
      return this;
    }

    public Builder setDeliveryItems(SetOrderDeliveryItems setDeliveryItems) {
      this.setDeliveryItems = setDeliveryItems;
      return this;
    }

    public Builder setItemShippingAddressCustomField(
        SetOrderItemShippingAddressCustomField setItemShippingAddressCustomField) {
      this.setItemShippingAddressCustomField = setItemShippingAddressCustomField;
      return this;
    }

    public Builder setItemShippingAddressCustomType(
        SetOrderItemShippingAddressCustomType setItemShippingAddressCustomType) {
      this.setItemShippingAddressCustomType = setItemShippingAddressCustomType;
      return this;
    }

    public Builder setLineItemCustomField(SetOrderLineItemCustomField setLineItemCustomField) {
      this.setLineItemCustomField = setLineItemCustomField;
      return this;
    }

    public Builder setLineItemCustomType(SetOrderLineItemCustomType setLineItemCustomType) {
      this.setLineItemCustomType = setLineItemCustomType;
      return this;
    }

    public Builder setLineItemShippingDetails(
        SetOrderLineItemShippingDetails setLineItemShippingDetails) {
      this.setLineItemShippingDetails = setLineItemShippingDetails;
      return this;
    }

    public Builder setLocale(SetOrderLocale setLocale) {
      this.setLocale = setLocale;
      return this;
    }

    public Builder setBusinessUnit(SetOrderBusinessUnit setBusinessUnit) {
      this.setBusinessUnit = setBusinessUnit;
      return this;
    }

    public Builder setOrderNumber(SetOrderNumber setOrderNumber) {
      this.setOrderNumber = setOrderNumber;
      return this;
    }

    public Builder setParcelCustomField(SetOrderParcelCustomField setParcelCustomField) {
      this.setParcelCustomField = setParcelCustomField;
      return this;
    }

    public Builder setParcelCustomType(SetOrderParcelCustomType setParcelCustomType) {
      this.setParcelCustomType = setParcelCustomType;
      return this;
    }

    public Builder setParcelItems(SetOrderParcelItems setParcelItems) {
      this.setParcelItems = setParcelItems;
      return this;
    }

    public Builder setParcelMeasurements(SetOrderParcelMeasurements setParcelMeasurements) {
      this.setParcelMeasurements = setParcelMeasurements;
      return this;
    }

    public Builder setParcelTrackingData(SetOrderParcelTrackingData setParcelTrackingData) {
      this.setParcelTrackingData = setParcelTrackingData;
      return this;
    }

    public Builder setPurchaseOrderNumber(SetOrderPurchaseOrderNumber setPurchaseOrderNumber) {
      this.setPurchaseOrderNumber = setPurchaseOrderNumber;
      return this;
    }

    public Builder setReturnInfo(SetOrderReturnInfo setReturnInfo) {
      this.setReturnInfo = setReturnInfo;
      return this;
    }

    public Builder setReturnItemCustomField(
        SetOrderReturnItemCustomField setReturnItemCustomField) {
      this.setReturnItemCustomField = setReturnItemCustomField;
      return this;
    }

    public Builder setReturnItemCustomType(SetOrderReturnItemCustomType setReturnItemCustomType) {
      this.setReturnItemCustomType = setReturnItemCustomType;
      return this;
    }

    public Builder setReturnPaymentState(SetOrderReturnPaymentState setReturnPaymentState) {
      this.setReturnPaymentState = setReturnPaymentState;
      return this;
    }

    public Builder setReturnShipmentState(SetOrderReturnShipmentState setReturnShipmentState) {
      this.setReturnShipmentState = setReturnShipmentState;
      return this;
    }

    public Builder setShippingAddress(SetOrderShippingAddress setShippingAddress) {
      this.setShippingAddress = setShippingAddress;
      return this;
    }

    public Builder setShippingAddressCustomField(
        SetOrderShippingAddressCustomField setShippingAddressCustomField) {
      this.setShippingAddressCustomField = setShippingAddressCustomField;
      return this;
    }

    public Builder setShippingAddressCustomType(
        SetOrderShippingAddressCustomType setShippingAddressCustomType) {
      this.setShippingAddressCustomType = setShippingAddressCustomType;
      return this;
    }

    public Builder setShippingCustomField(SetOrderShippingCustomField setShippingCustomField) {
      this.setShippingCustomField = setShippingCustomField;
      return this;
    }

    public Builder setShippingCustomType(SetOrderShippingCustomType setShippingCustomType) {
      this.setShippingCustomType = setShippingCustomType;
      return this;
    }

    public Builder setStore(SetOrderStore setStore) {
      this.setStore = setStore;
      return this;
    }

    public Builder transitionCustomLineItemState(
        TransitionOrderCustomLineItemState transitionCustomLineItemState) {
      this.transitionCustomLineItemState = transitionCustomLineItemState;
      return this;
    }

    public Builder transitionLineItemState(TransitionOrderLineItemState transitionLineItemState) {
      this.transitionLineItemState = transitionLineItemState;
      return this;
    }

    public Builder transitionState(TransitionOrderState transitionState) {
      this.transitionState = transitionState;
      return this;
    }

    public Builder updateItemShippingAddress(
        UpdateOrderItemShippingAddress updateItemShippingAddress) {
      this.updateItemShippingAddress = updateItemShippingAddress;
      return this;
    }

    public Builder updateSyncInfo(UpdateOrderSyncInfo updateSyncInfo) {
      this.updateSyncInfo = updateSyncInfo;
      return this;
    }
  }
}
