package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ParcelMeasurementsDraftType {
  private Integer heightInMillimeter;

  private Integer lengthInMillimeter;

  private Integer widthInMillimeter;

  private Integer weightInGram;

  public ParcelMeasurementsDraftType() {
  }

  public ParcelMeasurementsDraftType(Integer heightInMillimeter, Integer lengthInMillimeter,
      Integer widthInMillimeter, Integer weightInGram) {
    this.heightInMillimeter = heightInMillimeter;
    this.lengthInMillimeter = lengthInMillimeter;
    this.widthInMillimeter = widthInMillimeter;
    this.weightInGram = weightInGram;
  }

  public Integer getHeightInMillimeter() {
    return heightInMillimeter;
  }

  public void setHeightInMillimeter(Integer heightInMillimeter) {
    this.heightInMillimeter = heightInMillimeter;
  }

  public Integer getLengthInMillimeter() {
    return lengthInMillimeter;
  }

  public void setLengthInMillimeter(Integer lengthInMillimeter) {
    this.lengthInMillimeter = lengthInMillimeter;
  }

  public Integer getWidthInMillimeter() {
    return widthInMillimeter;
  }

  public void setWidthInMillimeter(Integer widthInMillimeter) {
    this.widthInMillimeter = widthInMillimeter;
  }

  public Integer getWeightInGram() {
    return weightInGram;
  }

  public void setWeightInGram(Integer weightInGram) {
    this.weightInGram = weightInGram;
  }

  @Override
  public String toString() {
    return "ParcelMeasurementsDraftType{heightInMillimeter='" + heightInMillimeter + "', lengthInMillimeter='" + lengthInMillimeter + "', widthInMillimeter='" + widthInMillimeter + "', weightInGram='" + weightInGram + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParcelMeasurementsDraftType that = (ParcelMeasurementsDraftType) o;
    return Objects.equals(heightInMillimeter, that.heightInMillimeter) &&
        Objects.equals(lengthInMillimeter, that.lengthInMillimeter) &&
        Objects.equals(widthInMillimeter, that.widthInMillimeter) &&
        Objects.equals(weightInGram, that.weightInGram);
  }

  @Override
  public int hashCode() {
    return Objects.hash(heightInMillimeter, lengthInMillimeter, widthInMillimeter, weightInGram);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer heightInMillimeter;

    private Integer lengthInMillimeter;

    private Integer widthInMillimeter;

    private Integer weightInGram;

    public ParcelMeasurementsDraftType build() {
      ParcelMeasurementsDraftType result = new ParcelMeasurementsDraftType();
      result.heightInMillimeter = this.heightInMillimeter;
      result.lengthInMillimeter = this.lengthInMillimeter;
      result.widthInMillimeter = this.widthInMillimeter;
      result.weightInGram = this.weightInGram;
      return result;
    }

    public Builder heightInMillimeter(Integer heightInMillimeter) {
      this.heightInMillimeter = heightInMillimeter;
      return this;
    }

    public Builder lengthInMillimeter(Integer lengthInMillimeter) {
      this.lengthInMillimeter = lengthInMillimeter;
      return this;
    }

    public Builder widthInMillimeter(Integer widthInMillimeter) {
      this.widthInMillimeter = widthInMillimeter;
      return this;
    }

    public Builder weightInGram(Integer weightInGram) {
      this.weightInGram = weightInGram;
      return this;
    }
  }
}
