package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ParcelTrackingDataUpdated implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String deliveryId;

  private String parcelId;

  private TrackingData trackingData;

  private String shippingKey;

  private String type;

  public ParcelTrackingDataUpdated() {
  }

  public ParcelTrackingDataUpdated(String deliveryId, String parcelId, TrackingData trackingData,
      String shippingKey, String type) {
    this.deliveryId = deliveryId;
    this.parcelId = parcelId;
    this.trackingData = trackingData;
    this.shippingKey = shippingKey;
    this.type = type;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public String getParcelId() {
    return parcelId;
  }

  public void setParcelId(String parcelId) {
    this.parcelId = parcelId;
  }

  public TrackingData getTrackingData() {
    return trackingData;
  }

  public void setTrackingData(TrackingData trackingData) {
    this.trackingData = trackingData;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ParcelTrackingDataUpdated{deliveryId='" + deliveryId + "', parcelId='" + parcelId + "', trackingData='" + trackingData + "', shippingKey='" + shippingKey + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParcelTrackingDataUpdated that = (ParcelTrackingDataUpdated) o;
    return Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(parcelId, that.parcelId) &&
        Objects.equals(trackingData, that.trackingData) &&
        Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deliveryId, parcelId, trackingData, shippingKey, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String deliveryId;

    private String parcelId;

    private TrackingData trackingData;

    private String shippingKey;

    private String type;

    public ParcelTrackingDataUpdated build() {
      ParcelTrackingDataUpdated result = new ParcelTrackingDataUpdated();
      result.deliveryId = this.deliveryId;
      result.parcelId = this.parcelId;
      result.trackingData = this.trackingData;
      result.shippingKey = this.shippingKey;
      result.type = this.type;
      return result;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder parcelId(String parcelId) {
      this.parcelId = parcelId;
      return this;
    }

    public Builder trackingData(TrackingData trackingData) {
      this.trackingData = trackingData;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
