package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class PatternComponentInput {
  private CountOnLineItemUnitsInput CountOnLineItemUnits;

  private CountOnCustomLineItemUnitsInput CountOnCustomLineItemUnits;

  public PatternComponentInput() {
  }

  public PatternComponentInput(CountOnLineItemUnitsInput CountOnLineItemUnits,
      CountOnCustomLineItemUnitsInput CountOnCustomLineItemUnits) {
    this.CountOnLineItemUnits = CountOnLineItemUnits;
    this.CountOnCustomLineItemUnits = CountOnCustomLineItemUnits;
  }

  public CountOnLineItemUnitsInput getCountOnLineItemUnits() {
    return CountOnLineItemUnits;
  }

  public void setCountOnLineItemUnits(CountOnLineItemUnitsInput CountOnLineItemUnits) {
    this.CountOnLineItemUnits = CountOnLineItemUnits;
  }

  public CountOnCustomLineItemUnitsInput getCountOnCustomLineItemUnits() {
    return CountOnCustomLineItemUnits;
  }

  public void setCountOnCustomLineItemUnits(
      CountOnCustomLineItemUnitsInput CountOnCustomLineItemUnits) {
    this.CountOnCustomLineItemUnits = CountOnCustomLineItemUnits;
  }

  @Override
  public String toString() {
    return "PatternComponentInput{CountOnLineItemUnits='" + CountOnLineItemUnits + "', CountOnCustomLineItemUnits='" + CountOnCustomLineItemUnits + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PatternComponentInput that = (PatternComponentInput) o;
    return Objects.equals(CountOnLineItemUnits, that.CountOnLineItemUnits) &&
        Objects.equals(CountOnCustomLineItemUnits, that.CountOnCustomLineItemUnits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(CountOnLineItemUnits, CountOnCustomLineItemUnits);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CountOnLineItemUnitsInput CountOnLineItemUnits;

    private CountOnCustomLineItemUnitsInput CountOnCustomLineItemUnits;

    public PatternComponentInput build() {
      PatternComponentInput result = new PatternComponentInput();
      result.CountOnLineItemUnits = this.CountOnLineItemUnits;
      result.CountOnCustomLineItemUnits = this.CountOnCustomLineItemUnits;
      return result;
    }

    public Builder CountOnLineItemUnits(CountOnLineItemUnitsInput CountOnLineItemUnits) {
      this.CountOnLineItemUnits = CountOnLineItemUnits;
      return this;
    }

    public Builder CountOnCustomLineItemUnits(
        CountOnCustomLineItemUnitsInput CountOnCustomLineItemUnits) {
      this.CountOnCustomLineItemUnits = CountOnCustomLineItemUnits;
      return this;
    }
  }
}
