package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class PaymentCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private Payment payment;

  private String type;

  public PaymentCreated() {
  }

  public PaymentCreated(Payment payment, String type) {
    this.payment = payment;
    this.type = type;
  }

  public Payment getPayment() {
    return payment;
  }

  public void setPayment(Payment payment) {
    this.payment = payment;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "PaymentCreated{payment='" + payment + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PaymentCreated that = (PaymentCreated) o;
    return Objects.equals(payment, that.payment) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payment, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Payment payment;

    private String type;

    public PaymentCreated build() {
      PaymentCreated result = new PaymentCreated();
      result.payment = this.payment;
      result.type = this.type;
      return result;
    }

    public Builder payment(Payment payment) {
      this.payment = payment;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
